/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.utils.OpenShiftUIUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeployImageWizard;

public class DeployImageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDockerImage selectedImage;
        ISelection dockerSelection;
        Connection connection = null;
        IProject project = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IDockerImage image = (IDockerImage)UIUtils.getFirstElement((ISelection)selection, IDockerImage.class);
        if (image == null || OpenShiftUIUtils.hasOpenShiftExplorerSelection()) {
            selection = OpenShiftUIUtils.getOpenShiftExplorerSelection();
            project = ResourceUtils.getProject((IResource)((IResource)UIUtils.getFirstElement((ISelection)selection, IResource.class)));
            connection = project != null ? ConnectionsRegistryUtil.getConnectionFor((IResource)project) : (Connection)UIUtils.getFirstElement((ISelection)selection, Connection.class);
        }
        if (connection == null) {
            connection = (Connection)OpenShiftUIUtils.getExplorerDefaultConnection(Connection.class);
        }
        IDockerConnection dockerConnection = null;
        if (image != null) {
            dockerConnection = image.getConnection();
        } else if (OpenShiftUIUtils.hasDockerExplorerSelection() && (dockerConnection = (IDockerConnection)UIUtils.getFirstElement((ISelection)(dockerSelection = OpenShiftUIUtils.getDockerExplorerSelection()), IDockerConnection.class)) == null && (selectedImage = (IDockerImage)UIUtils.getFirstElement((ISelection)dockerSelection, IDockerImage.class)) != null) {
            dockerConnection = selectedImage.getConnection();
        }
        this.runWizard(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), dockerConnection, image, project, connection);
        return null;
    }

    public void runWizard(final Shell shell, final IDockerConnection dockerConnection, final IDockerImage image, final IProject project, final Connection connection) {
        if (connection != null) {
            final boolean[] authorized = new boolean[1];
            AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob("Checking connection..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    try {
                        authorized[0] = connection.isAuthorized((IProgressMonitor)new NullProgressMonitor());
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return new Status(4, "org.jboss.tools.openshift.ui", "Unable to load the OpenShift projects for the selected connection.", (Throwable)e);
                    }
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DeployImageWizard wizard = new DeployImageWizard(dockerConnection, image, connection, project, authorized[0]);
                            WizardUtils.openWizardDialog((int)500, (int)500, (IWizard)wizard, (Shell)shell);
                        }
                    });
                }
            });
            job.schedule();
        } else {
            DeployImageWizard wizard = new DeployImageWizard(dockerConnection, image, connection, project, false);
            WizardUtils.openWizardDialog((int)600, (int)1500, (IWizard)wizard, (Shell)shell);
        }
    }
}

