/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.AggregatingConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.KeywordConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.NumericValidator;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIMessages;
import org.jboss.tools.openshift.internal.ui.wizard.common.EditResourceLimitsPageModel;

public class EditResourceLimitsPage
extends AbstractOpenShiftWizardPage {
    public static final String[] MEMORY_SUFFIXES = new String[]{"M", "G", "Mi", "Gi", ""};
    public static final String[] MEMORY_SUFFIXES_LABELS = new String[]{"MB (1000 KB)", "GB (1000 MB)", "MiB (1024 KB)", "GiB (1024 MB)", "bytes"};
    public static final String[] CPU_SUFFIXES = new String[]{"m", "k", "M", "G", ""};
    public static final String[] CPU_SUFFIXES_LABELS = new String[]{"millicores", "kcores", "Mcores", "Gcores", "cores"};
    private EditResourceLimitsPageModel model;

    public EditResourceLimitsPage(EditResourceLimitsPageModel model, IWizard wizard) {
        super(OpenShiftUIMessages.EditResourceLimitsPageTitle, NLS.bind((String)OpenShiftUIMessages.EditResourceLimitsPageDescription, (Object)model.getUpdatedReplicationController().getName()), "EditResourceLimitsPage", wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Composite dialogArea = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)dialogArea);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).spacing(20, -1).applyTo(dialogArea);
        Group group = new Group(dialogArea, 0);
        group.setText(OpenShiftUIMessages.MemoryLabel);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).align(4, 4).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).spacing(10, 4).applyTo((Composite)group);
        this.createResourceWidgets(OpenShiftUIMessages.RequestLabel, "requestsMemory", MEMORY_SUFFIXES, MEMORY_SUFFIXES_LABELS, group, dbc);
        this.createResourceWidgets(OpenShiftUIMessages.LimitLabel, "limitsMemory", MEMORY_SUFFIXES, MEMORY_SUFFIXES_LABELS, group, dbc);
        group = new Group(dialogArea, 0);
        group.setText(OpenShiftUIMessages.CPULabel);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).align(4, 4).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).spacing(10, 4).applyTo((Composite)group);
        this.createResourceWidgets(OpenShiftUIMessages.RequestLabel, "requestsCPU", CPU_SUFFIXES, CPU_SUFFIXES_LABELS, group, dbc);
        this.createResourceWidgets(OpenShiftUIMessages.LimitLabel, "limitsCPU", CPU_SUFFIXES, CPU_SUFFIXES_LABELS, group, dbc);
    }

    private void createResourceWidgets(String label, String property, final String[] suffixes, final String[] labels, Group parent, DataBindingContext dbc) {
        Label labelComp = new Label((Composite)parent, 0);
        labelComp.setText(label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)labelComp);
        Text text = new Text((Composite)parent, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)text);
        ComboViewer combo = new ComboViewer((Composite)parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(140, -1).applyTo(combo.getControl());
        combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        combo.setInput((Object)suffixes);
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return this.getLabelForSuffix(element, suffixes, labels);
            }

            private String getLabelForSuffix(Object element, String[] suffixes2, String[] labels2) {
                String label = (String)element;
                int i = 0;
                while (i < suffixes2.length) {
                    if (element.equals(suffixes2[i])) {
                        label = labels2[i];
                        break;
                    }
                    ++i;
                }
                return label;
            }
        });
        ISWTObservableValue valueObservable = WidgetProperties.text((int)24).observe((Widget)text);
        IViewerObservableValue selectedUnitObservable = ViewerProperties.singleSelection().observe((Viewer)combo);
        IObservableValue master = BeanProperties.value((String)"selectedContainer").observe((Object)this.model);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)valueObservable).validatingAfterGet((IValidator)new NumericValidator("integer", Integer::parseInt))).converting((IConverter)new AggregatingConverter((IObservableValue)selectedUnitObservable, true))).to(PojoProperties.value((String)property).observeDetail(master)).converting((IConverter)new KeywordConverter(suffixes, true))).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedUnitObservable).converting((IConverter)new AggregatingConverter((IObservableValue)valueObservable, false))).to(PojoProperties.value((String)property).observeDetail(master)).converting((IConverter)new KeywordConverter(suffixes, false))).in(dbc);
    }
}

