/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.ImportApplicationWizard;

public class ImportApplicationHandler
extends AbstractHandler {
    private static final String NO_BUILD_CONFIG_MSG = "No Build configuration to import";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        IBuildConfig buildConfig = (IBuildConfig)UIUtils.getFirstElement((ISelection)currentSelection, IBuildConfig.class);
        Map<IProject, Set<IBuildConfig>> projectsAndBuildConfigs = null;
        IProject project = null;
        Collection<Object> buildConfigs = null;
        if (buildConfig == null) {
            IResource resource = (IResource)UIUtils.getFirstElement((ISelection)currentSelection, IResource.class);
            if (resource != null) {
                project = resource.getProject();
            }
            if (project != null) {
                buildConfigs = project.getResources("BuildConfig");
            }
        } else {
            project = buildConfig.getProject();
            buildConfigs = Collections.singleton(buildConfig);
        }
        if (project != null) {
            if (buildConfigs == null || buildConfigs.isEmpty()) {
                MessageDialog.openWarning((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)NO_BUILD_CONFIG_MSG, (String)NO_BUILD_CONFIG_MSG);
                return OpenShiftUIActivator.statusFactory().cancelStatus(NO_BUILD_CONFIG_MSG);
            }
            projectsAndBuildConfigs = Collections.singletonMap(project, buildConfigs);
        }
        if (projectsAndBuildConfigs == null) {
            ImportApplicationWizard wizard = new ImportApplicationWizard();
            Connection connection = (Connection)UIUtils.getFirstElement((ISelection)currentSelection, Connection.class);
            wizard.setConnection(connection);
            WizardUtils.openWizardDialog((IWorkbenchWizard)wizard, (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event));
        } else {
            WizardUtils.openWizardDialog((IWorkbenchWizard)new ImportApplicationWizard(projectsAndBuildConfigs), (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event));
        }
        return Status.OK_STATUS;
    }
}

