/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IReplicationController;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.handler.ManageEnvironmentVariablesWizard;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.IServiceWrapper;

public class ManageEnvironmentVariablesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IReplicationController rc = this.findReplicationController(event);
        if (rc != null) {
            ManageEnvironmentVariablesWizard wizard = new ManageEnvironmentVariablesWizard(rc);
            WizardUtils.openWizardDialog((IWizard)wizard, (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event));
        }
        return null;
    }

    IReplicationController findReplicationController(ExecutionEvent event) {
        ISelection selection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        IDeploymentConfig dc = (IDeploymentConfig)UIUtils.getFirstElement((ISelection)selection, IDeploymentConfig.class);
        if (dc != null) {
            return dc;
        }
        IReplicationController rc = (IReplicationController)UIUtils.getFirstElement((ISelection)selection, IReplicationController.class);
        if (rc != null) {
            return rc;
        }
        IServiceWrapper deployment = (IServiceWrapper)UIUtils.getFirstElement((ISelection)selection, IServiceWrapper.class);
        Collection dcs = deployment.getResourcesOfKind("DeploymentConfig");
        if (!dcs.isEmpty() && (dc = (IDeploymentConfig)((IResourceWrapper)dcs.iterator().next()).getWrapped()) != null) {
            return dc;
        }
        return null;
    }
}

