/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IEvent;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.volume.IPersistentVolumeClaim;
import java.util.function.Function;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class OpenInWebConsoleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String msg;
        ISelection currentSelection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        IResource resource = (IResource)UIUtils.getFirstElement((ISelection)currentSelection, IResource.class);
        Connection connection = null;
        connection = resource == null ? (Connection)UIUtils.getFirstElement((ISelection)currentSelection, Connection.class) : ConnectionsRegistryUtil.safeGetConnectionFor((IResource)resource);
        if (connection == null) {
            msg = "Could not find an OpenShift connection to open a console for";
        } else {
            String url = this.getWebConsoleUrl(connection, resource);
            if (!StringUtils.isEmpty((String)url)) {
                new BrowserUtility().checkedCreateExternalBrowser(url, "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
                return Status.OK_STATUS;
            }
            msg = NLS.bind((String)"Could not determine the url for the web console on {0}", (Object)connection.getHost());
        }
        MessageDialog.openWarning((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"No Web Console Url", (String)msg);
        return new Status(2, "org.jboss.tools.openshift.ui", msg);
    }

    protected String getWebConsoleUrl(Connection connection, IResource resource) {
        String projectName;
        StringBuilder url = new StringBuilder(connection.getHost()).append("/console");
        String string = projectName = resource == null ? null : resource.getNamespace();
        if (projectName != null) {
            url.append("/project/").append(projectName);
        }
        if (resource != null && !(resource instanceof IProject)) {
            url.append(this.getResourceURL(resource));
        }
        return url.toString();
    }

    protected String getResourceURL(IResource resource) {
        ResourceUrls[] resourceUrlsArray = ResourceUrls.values();
        int n = resourceUrlsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceUrls resUrl = resourceUrlsArray[n2];
            if (resUrl.getResType().isInstance(resource)) {
                return String.valueOf(resUrl.getUrlPart()) + resUrl.getEndUrlFunc().apply(resource);
            }
            ++n2;
        }
        return "/browse";
    }

    protected static enum ResourceUrls {
        BuildConfig(IBuildConfig.class, "/browse/builds/", IResource::getName),
        Build(IBuild.class, "/browse/builds/", r -> String.join((CharSequence)"/", (CharSequence)r.getLabels().get("buildconfig"), r.getName())),
        DeploymentConfig(IDeploymentConfig.class, "/browse/deployments/", IResource::getName),
        Pod(IPod.class, "/browse/pods/", IResource::getName),
        Service(IService.class, "/browse/services/", IResource::getName),
        ImageStream(IImageStream.class, "/browse/images/", IResource::getName),
        PersistentVolumeClaim(IPersistentVolumeClaim.class, "/browse/persistentvolumeclaims/", IResource::getName),
        Event(IEvent.class, "/browse/events/", r -> "");

        private final Class<? extends IResource> resType;
        private final String urlPart;
        private final Function<IResource, String> endUrlFunc;

        private ResourceUrls(Class<? extends IResource> resType, String urlPart, Function<IResource, String> endUrlFunc) {
            this.resType = resType;
            this.urlPart = urlPart;
            this.endUrlFunc = endUrlFunc;
        }

        public Class<? extends IResource> getResType() {
            return this.resType;
        }

        public String getUrlPart() {
            return this.urlPart;
        }

        public Function<IResource, String> getEndUrlFunc() {
            return this.endUrlFunc;
        }
    }
}

