/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IContainer;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.handler.AbstractOpenShiftCliHandler;
import org.jboss.tools.openshift.internal.ui.job.PodLogsJob;

public class PodLogsHandler
extends AbstractOpenShiftCliHandler {
    private static final String[] STATES = new String[]{"Running", "Succeeded", "Failed", "Completed", "Error"};
    public static final String INVALID_POD_STATUS_MESSAGE = "The log is unavailable while the pod is in {0} state.";

    protected <T> T getSelectedElement(ExecutionEvent event, Class<T> klass) {
        ISelection selection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        return (T)UIUtils.getFirstElement((ISelection)selection, klass);
    }

    @Override
    protected void handleEvent(ExecutionEvent event) {
        IPod pod = this.getSelectedElement(event, IPod.class);
        if (pod == null && (pod = this.getPodFromBuild(event)) == null) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"No pod selected", (String)"Unable to determine the build pod in order to retrieve its log.");
            return;
        }
        this.showLogs(pod, event);
    }

    protected void showDialog(ExecutionEvent event, String title, String message) {
        MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)title, (String)message);
    }

    protected void showLogs(IPod pod, ExecutionEvent event) {
        if (pod == null) {
            this.showDialog(event, "No pod selected", "No pod was selected to retrieve a log.");
            return;
        }
        if (!ArrayUtils.contains((Object[])STATES, (Object)pod.getStatus())) {
            this.showDialog(event, "Logs Unavailable", NLS.bind((String)INVALID_POD_STATUS_MESSAGE, (Object)pod.getStatus()));
            return;
        }
        Collection containers = pod.getContainers();
        if (containers.isEmpty()) {
            this.showDialog(event, "Logs Unavailable", "There are no containers from which to retrieve logs");
            return;
        }
        String containerName = null;
        if (containers.size() > 1) {
            List names = containers.stream().map(c -> c.getName()).collect(Collectors.toList());
            Collections.sort(names);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (ILabelProvider)new LabelProvider());
            dialog.setElements(names.toArray());
            dialog.setTitle("Pod Containers");
            dialog.setMessage("Select a pod container");
            dialog.setMultipleSelection(false);
            int result = dialog.open();
            if (1 == result) {
                return;
            }
            containerName = (String)dialog.getFirstResult();
        } else if (containers.size() == 1) {
            containerName = ((IContainer)containers.iterator().next()).getName();
        }
        new PodLogsJob(pod, containerName).schedule();
    }

    private IConnection getConnectionFromBuild(ExecutionEvent event) {
        IBuild build = this.getSelectedElement(event, IBuild.class);
        if (build != null) {
            return ConnectionsRegistryUtil.safeGetConnectionFor((IResource)build);
        }
        return null;
    }

    private IPod getPodFromBuild(ExecutionEvent event) {
        IBuild build = this.getSelectedElement(event, IBuild.class);
        if (build != null) {
            String buildName = build.getName();
            Connection connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)build);
            List pods = connection.getResources("Pod", build.getNamespace());
            for (IPod pod : pods) {
                if (!buildName.equals(pod.getAnnotation("openshift.io/build.name"))) continue;
                return pod;
            }
        }
        return null;
    }

    @Override
    protected IConnection getConnection(ExecutionEvent event) {
        return this.getConnectionFromBuild(event);
    }
}

