/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.OpenShiftException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.models.IOpenshiftUIElement;

public class RefreshResourceHandler
extends AbstractHandler {
    private static final String FAILED_TO_REFRESH_ELEMENT = "Failed to refresh element";
    private static final String LOADING_OPEN_SHIFT_INFORMATIONS = "Loading OpenShift information...";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = UIUtils.getCurrentSelection((ExecutionEvent)event);
        IOpenshiftUIElement element = (IOpenshiftUIElement)UIUtils.getFirstElement((ISelection)selection, IOpenshiftUIElement.class);
        if (element != null) {
            this.refresh(element);
        }
        return null;
    }

    private void refresh(IOpenshiftUIElement<?, ?> element) {
        Job job = null;
        job = this.createRefreshJob(element);
        job.schedule();
    }

    private Job createRefreshJob(final IOpenshiftUIElement<?, ?> element) {
        return new AbstractDelegatingMonitorJob(LOADING_OPEN_SHIFT_INFORMATIONS){

            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask(RefreshResourceHandler.LOADING_OPEN_SHIFT_INFORMATIONS, -1);
                        element.refresh();
                    }
                    catch (OpenShiftException e) {
                        OpenShiftCommonUIActivator.getDefault().getLogger().logError(RefreshResourceHandler.FAILED_TO_REFRESH_ELEMENT, (Throwable)e);
                        Status status = new Status(4, "org.jboss.tools.openshift.ui", RefreshResourceHandler.FAILED_TO_REFRESH_ELEMENT, (Throwable)e);
                        monitor.done();
                        return status;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
    }
}

