/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.route.IRoute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

class SelectedRoutePreference {
    public static final String SELECTED_ROUTE = "org.jboss.tools.openshift.selectedRoute";
    public static final SelectedRoutePreference instance = new SelectedRoutePreference();
    static final int HISTORY_LIMIT = 100;
    static final String ITEMS_SEPARATOR = ";";
    static final String ITEM_SEPARATOR = "|";
    static final String KEY_SEPARATOR = ",";
    IPreferenceStore preferences = OpenShiftUIActivator.getDefault().getCorePreferenceStore();
    Map<String, String> choices = new HashMap<String, String>();
    List<String> history = new ArrayList<String>();

    public SelectedRoutePreference() {
        this.load(this.preferences.getString(SELECTED_ROUTE));
    }

    private void load(String storedValue) {
        String[] items;
        if (StringUtils.isBlank((String)storedValue)) {
            return;
        }
        String[] stringArray = items = storedValue.split(ITEMS_SEPARATOR);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String[] keys;
            String item = stringArray[n2];
            if (!StringUtils.isBlank((String)item) && (keys = item.split(ITEM_SEPARATOR)).length == 2) {
                this.history.add(keys[0]);
                this.choices.put(keys[0], keys[1]);
            }
            ++n2;
        }
    }

    public IRoute getSelectedRoute(List<IRoute> routes) {
        String key = this.getKey(routes);
        if (this.choices.containsKey(key)) {
            String selectedRoute = this.choices.get(key);
            for (IRoute route : routes) {
                if (!selectedRoute.equals(this.getKey(route))) continue;
                this.history.remove(key);
                this.history.add(key);
                return route;
            }
        }
        return null;
    }

    public void setSelectedRoute(List<IRoute> routes, IRoute route) {
        String routesKey = this.getKey(routes);
        String routeKey = this.getKey(route);
        if (routeKey == null) {
            return;
        }
        this.choices.put(routesKey, routeKey);
        this.history.remove(routesKey);
        this.history.add(routesKey);
        if (this.history.size() > 100) {
            String ancient = this.history.remove(0);
            this.choices.remove(ancient);
        }
        this.save();
    }

    private void save() {
        StringBuilder preference = new StringBuilder();
        for (String _routesKey : this.history) {
            String _routeKey = this.choices.get(_routesKey);
            if (preference.length() > 0) {
                preference.append(ITEMS_SEPARATOR);
            }
            preference.append(_routesKey).append(ITEM_SEPARATOR).append(_routeKey);
        }
        this.preferences.putValue(SELECTED_ROUTE, preference.toString());
        try {
            if (this.preferences instanceof IPersistentPreferenceStore) {
                ((IPersistentPreferenceStore)this.preferences).save();
            }
        }
        catch (IOException e) {
            OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public void removeSelectedRoute(List<IRoute> routes) {
        String routesKey = this.getKey(routes);
        if (this.choices.containsKey(routesKey)) {
            this.choices.remove(routesKey);
            this.history.remove(routesKey);
            this.save();
        }
    }

    String getKey(List<IRoute> routes) {
        TreeSet<String> set = new TreeSet<String>();
        for (IRoute route : routes) {
            String key = this.getKey(route);
            if (key == null) continue;
            set.add(key);
        }
        StringBuilder sb = new StringBuilder();
        for (String key : set) {
            if (sb.length() > 0) {
                sb.append(KEY_SEPARATOR);
            }
            sb.append(key);
        }
        return sb.toString();
    }

    String getKey(IRoute route) {
        return route.getURL();
    }
}

