/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IEnvironmentVariable;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.build.IBuildConfigBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jboss.dmr.ModelNode;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryDialog;
import org.jboss.tools.openshift.internal.ui.job.DeployImageJob;
import org.jboss.tools.openshift.internal.ui.job.IResourcesModelJob;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariable;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImageParameters;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.fromimage.IBuildConfigPageModel;

public class CreateApplicationFromImageJob
extends DeployImageJob
implements IResourcesModelJob {
    private IBuildConfigPageModel buildConfigModel;

    public CreateApplicationFromImageJob(IBuildConfigPageModel buildConfigModel, IDeployImageParameters deployImageModel) {
        super("Create Application From Builder Image Job", deployImageModel);
        this.buildConfigModel = buildConfigModel;
    }

    @Override
    public Job getJob() {
        return this;
    }

    @Override
    public Runnable getSummaryRunnable(final Shell shell) {
        return new Runnable(){

            @Override
            public void run() {
                String message = NLS.bind((String)"Results of creating the resources from the {0}/{1} builder image.", (Object)CreateApplicationFromImageJob.this.buildConfigModel.getBuilderImageNamespace(), (Object)CreateApplicationFromImageJob.this.buildConfigModel.getBuilderImageName());
                new ResourceSummaryDialog(shell, CreateApplicationFromImageJob.this.getResources(), "Create Application Summary", message).open();
            }
        };
    }

    @Override
    protected void addToGeneratedResources(Map<String, IResource> resources, Connection connection, String name, IProject project) {
        IBuildConfigBuilder builder = (IBuildConfigBuilder)connection.getResourceBuilder(IBuildConfigBuilder.class);
        IBuildConfig bc = (IBuildConfig)((IBuildConfigBuilder)((IBuildConfigBuilder)builder.named(name)).inNamespace(project.getName())).fromGitSource().fromGitUrl(this.buildConfigModel.getGitRepositoryUrl()).usingGitReference(this.buildConfigModel.getGitReference()).inContextDir(this.buildConfigModel.getContextDir()).end().usingSourceStrategy().fromImageStreamTag(this.buildConfigModel.getBuilderImageName()).inNamespace(this.buildConfigModel.getBuilderImageNamespace()).withEnvVars(this.createEnvVars()).end().buildOnSourceChange(this.buildConfigModel.isConfigWebHook()).buildOnConfigChange(this.buildConfigModel.isConfigChangeTrigger()).buildOnImageChange(this.buildConfigModel.isImageChangeTrigger()).toImageStreamTag(new DockerImageURI(name).getNameAndTag()).build();
        resources.put("BuildConfig", (IResource)bc);
    }

    @Override
    public IResource stubDeploymentConfig(IResourceFactory factory, String name, DockerImageURI imageUri, IImageStream is) {
        return super.stubDeploymentConfig(factory, name, new DockerImageURI(name), is);
    }

    @Override
    protected IImageStream stubImageStream(IResourceFactory factory, String name, IProject project, DockerImageURI imageUri) {
        return (IImageStream)factory.stub("ImageStream", name, project.getName());
    }

    private List<IEnvironmentVariable> createEnvVars() {
        ArrayList<IEnvironmentVariable> list = new ArrayList<IEnvironmentVariable>();
        this.buildConfigModel.getEnvVariablesModel().getEnvironmentVariables().forEach(v -> {
            boolean bl = list.add(new IEnvironmentVariable((EnvironmentVariable)v){
                private final /* synthetic */ EnvironmentVariable val$v;
                {
                    this.val$v = environmentVariable;
                }

                public String getName() {
                    return this.val$v.getKey();
                }

                public String getValue() {
                    return this.val$v.getValue();
                }

                public IEnvironmentVariable.IEnvVarSource getValueFrom() {
                    return null;
                }

                public String toJson() {
                    ModelNode node = new ModelNode();
                    node.get("name").set(this.getName());
                    node.get("value").set(this.getValue());
                    return node.toJSONString(true);
                }
            });
        });
        return list;
    }
}

