/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IClientCapability;
import com.openshift.restclient.model.IList;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class CreateResourceJob
extends AbstractDelegatingMonitorJob {
    private IProject project;
    private InputStream input;
    private Collection<IResource> resource;

    public CreateResourceJob(IProject project, InputStream input) {
        super("Create Resource Job");
        this.project = project;
        this.input = input;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        return CreateResourceJob.loadResource(this.project, this.input, value -> {
            Collection collection = this.resource = value;
        });
    }

    public static IStatus loadResource(final IProject project, final InputStream input, final Consumer<Collection<IResource>> resourceListener) {
        return (IStatus)project.accept((CapabilityVisitor)new CapabilityVisitor<IClientCapability, IStatus>(){

            public IStatus visit(IClientCapability capability) {
                try {
                    IClient client = capability.getClient();
                    IResource resourceIn = client.getResourceFactory().create(input);
                    if (resourceListener != null) {
                        List<IResource> resources = resourceIn instanceof IList ? client.create((IList)resourceIn, project.getNamespace()) : Collections.singletonList(client.create(resourceIn, project.getNamespace()));
                        resourceListener.accept(resources);
                    }
                    return new Status(0, "org.jboss.tools.openshift.ui", "Resource created");
                }
                catch (OpenShiftException e) {
                    String message = e.getMessage();
                    if (e.getStatus() != null) {
                        message = e.getStatus().getMessage();
                    }
                    return new Status(4, "org.jboss.tools.openshift.ui", -1, message, (Throwable)e);
                }
            }
        }, (Object)new Status(4, "org.jboss.tools.openshift.ui", "Client processing is unsupported for this client and server combination.", null));
    }

    public Collection<IResource> getResource() {
        return this.resource;
    }
}

