/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.NotFoundException;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.IServicePort;
import com.openshift.restclient.model.deploy.IDeploymentImageChangeTrigger;
import com.openshift.restclient.model.route.IRoute;
import com.openshift.restclient.model.route.ITargetPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.core.ICommonAttributes;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.core.Trace;
import org.jboss.tools.openshift.internal.core.docker.DockerImageUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.job.IResourcesModel;
import org.jboss.tools.openshift.internal.ui.job.ResourceCreationJobUtils;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariable;
import org.jboss.tools.openshift.internal.ui.wizard.common.IResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImageParameters;

public class DeployImageJob
extends AbstractDelegatingMonitorJob
implements IResourcesModel,
ICommonAttributes {
    public static final String SELECTOR_KEY = "deploymentconfig";
    private static final String JBOSSTOOLS_OPENSHIFT = "jbosstools-openshift";
    private static final String MSG_NO_IMAGESTREAM = "{0} Note: Could not find an image stream\nfor {1} and/or the image is not available to the cluster.\nMake sure that a Docker image with that tag is available on the node for the\ndeployment to succeed.";
    private IDeployImageParameters parameters;
    private Collection<IResource> created = Collections.emptyList();
    private String summaryMessage;

    public DeployImageJob(IDeployImageParameters parameters) {
        this("Deploy Image Job", parameters);
    }

    protected DeployImageJob(String title, IDeployImageParameters parameters) {
        super(title);
        this.parameters = parameters;
        this.summaryMessage = NLS.bind((String)"Results of deploying image \"{0}\".", (Object)parameters.getResourceName());
    }

    protected IDeployImageParameters getParameters() {
        return this.parameters;
    }

    public String getSummaryMessage() {
        return this.summaryMessage;
    }

    @Override
    public Collection<IResource> getResources() {
        return this.created;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            Connection connection = (Connection)this.parameters.getConnection();
            String name = this.parameters.getResourceName();
            if (this.updateTriggerIfUpdate(connection, this.parameters.getProject().getName(), name)) {
                return Status.OK_STATUS;
            }
            Map<String, IResource> resources = this.generateResources(connection, name);
            Collection<IResource> existing = ResourceCreationJobUtils.findExistingResources(connection, resources.values());
            if (!existing.isEmpty()) {
                return ResourceCreationJobUtils.createErrorStatusForExistingResources(existing);
            }
            this.created = this.createResources(connection, resources.values());
        }
        catch (Exception e) {
            String message = NLS.bind((String)"Unable to create resources to deploy image {0}", (Object)this.parameters.getImageName());
            OpenShiftUIActivator.getDefault().getLogger().logError(message, (Throwable)e);
            return new Status(4, "org.jboss.tools.openshift.ui", message, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected boolean updateTriggerIfUpdate(Connection connection, String project, String name) {
        IDeploymentImageChangeTrigger trigger;
        IDeploymentConfig dc;
        block6: {
            dc = (IDeploymentConfig)connection.getResource("DeploymentConfig", project, name);
            trigger = dc.getTriggers().stream().filter(t -> "ImageChange".equals(t.getType())).findFirst().orElse(null);
            if (trigger != null && "ImageStreamTag".equals(trigger.getKind()) && !StringUtils.isBlank((String)trigger.getNamespace()) && connection.getResource("ImageStream", trigger.getNamespace(), trigger.getFrom().getName()) != null) break block6;
            return false;
        }
        try {
            DockerImageURI sourceImage = this.getSourceImage();
            if (sourceImage.getName().equals(trigger.getFrom().getName()) && !sourceImage.getTag().equals(trigger.getFrom().getTag())) {
                trigger.setFrom(new DockerImageURI(null, null, sourceImage.getName(), sourceImage.getTag()));
                connection.updateResource((IResource)dc);
            }
            return true;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
        catch (OpenShiftException e) {
            if (e.getStatus() != null && e.getStatus().getCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    private Collection<IResource> createResources(Connection connection, Collection<IResource> resources) {
        ArrayList<IResource> created = new ArrayList<IResource>();
        for (IResource resource : resources) {
            Trace.debug((String)"Trying to create resource: {0}", (Object[])new Object[]{resource.toJson()});
            try {
                created.add(connection.createResource(resource));
            }
            catch (OpenShiftException e) {
                if (e.getStatus() != null) {
                    created.add((IResource)e.getStatus());
                    OpenShiftUIActivator.getDefault().getLogger().logError(NLS.bind((String)"Error creating resource: {0}", (Object)e.getStatus().toJson()));
                    continue;
                }
                throw e;
            }
        }
        return created;
    }

    private Map<String, IResource> generateResources(Connection connection, String name) {
        IResourceFactory factory = connection.getResourceFactory();
        IProject project = this.parameters.getProject();
        DockerImageURI sourceImage = this.getSourceImage();
        HashMap<String, IResource> resources = new HashMap<String, IResource>(4);
        IImageStream is = this.stubImageStream(factory, name, project, sourceImage);
        if (is != null && StringUtils.isBlank((String)is.getResourceVersion())) {
            resources.put("ImageStream", (IResource)is);
        }
        resources.put("Service", (IResource)this.stubService(factory, name, SELECTOR_KEY, name));
        if (this.parameters.isAddRoute()) {
            resources.put("Route", this.stubRoute(factory, name, ((IResource)resources.get("Service")).getName()));
        }
        resources.put("DeploymentConfig", this.stubDeploymentConfig(factory, name, sourceImage, is));
        this.addToGeneratedResources(resources, connection, name, project);
        for (IResource resource : resources.values()) {
            this.addLabelsToResource(resource);
            resource.setAnnotation("openshift.io/generated-by", JBOSSTOOLS_OPENSHIFT);
        }
        return resources;
    }

    protected void addToGeneratedResources(Map<String, IResource> resources, Connection connection, String name, IProject project) {
    }

    protected DockerImageURI getSourceImage() {
        String imageName = this.parameters.isPushImageToRegistry() ? String.valueOf(this.parameters.getProject().getName()) + "/" + DockerImageUtils.extractImageNameAndTag((String)this.parameters.getImageName()) : this.parameters.getImageName();
        return new DockerImageURI(imageName);
    }

    protected IResource stubDeploymentConfig(IResourceFactory factory, String name, DockerImageURI imageUri, IImageStream is) {
        IDeploymentConfig dc = (IDeploymentConfig)factory.stub("DeploymentConfig", name, this.parameters.getProject().getName());
        dc.addLabel(SELECTOR_KEY, name);
        dc.addTemplateLabel(SELECTOR_KEY, name);
        for (IResourceLabelsPageModel.Label label : this.parameters.getLabels()) {
            dc.addTemplateLabel(label.getName(), label.getValue());
        }
        dc.setReplicas(this.parameters.getReplicas());
        dc.setReplicaSelector(SELECTOR_KEY, name);
        Map<String, String> envs = this.getModifiedEnvVars(this.parameters.getEnvironmentVariables(), this.parameters.getImageEnvVars());
        dc.addContainer(dc.getName(), imageUri, new HashSet(this.parameters.getPortSpecs()), envs, this.parameters.getVolumes());
        dc.addTrigger("ConfigChange");
        if (is != null) {
            IDeploymentImageChangeTrigger imageChangeTrigger = (IDeploymentImageChangeTrigger)dc.addTrigger("ImageChange");
            imageChangeTrigger.setAutomatic(true);
            imageChangeTrigger.setContainerName(name);
            imageChangeTrigger.setFrom(new DockerImageURI(null, null, is.getName(), imageUri.getTag()));
            imageChangeTrigger.setKind("ImageStreamTag");
            imageChangeTrigger.setNamespace(is.getNamespace());
        }
        return dc;
    }

    private Map<String, String> getModifiedEnvVars(Collection<EnvironmentVariable> envVars, Map<String, String> dockerEnvVars) {
        HashMap<String, String> envs = new HashMap<String, String>();
        for (EnvironmentVariable var : this.parameters.getEnvironmentVariables()) {
            if (StringUtils.defaultIfEmpty((String)dockerEnvVars.get(var.getKey()), (String)"").equals(var.getValue())) continue;
            envs.put(var.getKey(), var.getValue());
        }
        return envs;
    }

    protected IImageStream stubImageStream(IResourceFactory factory, String name, IProject project, DockerImageURI imageUri) {
        IImageStream is = this.findImageStreamFor(project.getName(), imageUri);
        if (is == null) {
            if (StringUtils.isNotBlank((String)((Connection)this.getParameters().getConnection()).getClusterNamespace())) {
                is = this.findImageStreamFor(((Connection)this.getParameters().getConnection()).getClusterNamespace(), imageUri);
            }
            if (is == null && this.isImageVisibleByOpenShift(project, imageUri)) {
                is = (IImageStream)factory.stub("ImageStream", name, project.getName());
                is.addTag(imageUri.getTag(), "DockerImage", imageUri.toString());
            }
        }
        if (is == null) {
            this.summaryMessage = NLS.bind((String)MSG_NO_IMAGESTREAM, (Object)this.summaryMessage, (Object)this.parameters.getImageName());
        }
        return is;
    }

    private IImageStream findImageStreamFor(String namespace, DockerImageURI uri) {
        Connection connection = (Connection)this.parameters.getConnection();
        try {
            List streams = connection.getResources("ImageStream", namespace);
            return streams.stream().filter(is -> is.getDockerImageRepository() != null && is.getDockerImageRepository().getUriUserNameAndName().equals(uri.getUriUserNameAndName())).findFirst().orElse(null);
        }
        catch (OpenShiftException e) {
            OpenShiftUIActivator.log(4, e.getLocalizedMessage(), e);
            return null;
        }
    }

    protected boolean isImageVisibleByOpenShift(IProject project, DockerImageURI uri) {
        return DockerImageUtils.lookupImageMetadata((IProject)project, (DockerImageURI)uri) != null;
    }

    private IResource stubRoute(IResourceFactory factory, String name, String serviceName) {
        IServicePort port;
        IRoute route = (IRoute)factory.stub("Route", name, this.parameters.getProject().getName());
        route.setServiceName(serviceName);
        String hostname = this.parameters.getRouteHostname();
        if (StringUtils.isNotBlank((String)hostname)) {
            route.setHost(hostname);
        }
        if ((port = this.parameters.getRoutingPort()) != null) {
            ITargetPort targetPort = route.createPort();
            if (port.getName() != null) {
                targetPort.setTargetPortName(port.getName());
            } else {
                targetPort.setTargetPort(Integer.valueOf(port.getPort()));
            }
        }
        return route;
    }

    private IService stubService(IResourceFactory factory, String name, String selectorKey, String selectorValue) {
        IService service = (IService)factory.stub("Service", name, this.parameters.getProject().getName());
        service.setPorts(this.parameters.getServicePorts());
        service.setSelector(selectorKey, selectorValue);
        return service;
    }

    private void addLabelsToResource(IResource resource) {
        for (IResourceLabelsPageModel.Label label : this.parameters.getLabels()) {
            resource.addLabel(label.getName(), label.getValue());
        }
    }
}

