/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.core.connection.IOpenShiftConnection;
import org.jboss.tools.openshift.internal.core.WatchManager;
import org.jboss.tools.openshift.internal.ui.job.DeleteResourceJob;

public class OpenShiftJobs {
    private static final long PROJECT_DELETE_DELAY = 500L;
    private static final long MAX_PROJECT_DELETE_DELAY = 5000L;

    private OpenShiftJobs() {
    }

    public static DeleteResourceJob createDeleteProjectJob(final IProject project) {
        Assert.isNotNull((Object)project, (String)"A project must not be null");
        return new DeleteResourceJob((IResource)project){

            @Override
            protected IStatus doRun(IProgressMonitor monitor) {
                Connection connection = ConnectionsRegistryUtil.getConnectionFor((IResource)project);
                WatchManager.getInstance().stopWatch(project, (IOpenShiftConnection)connection);
                List oldProjects = connection.getResources("Project");
                IStatus status = super.doRun(monitor);
                if (status.isOK() && this.waitForServerToReconcileProjectDelete(connection, project)) {
                    ArrayList newProjects = new ArrayList(oldProjects);
                    newProjects.remove(project);
                    ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)connection, "openshift.projects", (Object)oldProjects, newProjects);
                }
                return status;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean waitForServerToReconcileProjectDelete(Connection conn, IProject project2) {
                boolean deleted = false;
                long sleep = 0L;
                do {
                    try {
                        try {
                            conn.refresh((IResource)project2);
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            sleep += 500L;
                            continue;
                        }
                        catch (OpenShiftException ex) {
                            int code;
                            if (ex.getStatus() != null && ((code = ex.getStatus().getCode()) == 404 || code == 403)) {
                                deleted = true;
                            }
                            sleep += 500L;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        sleep += 500L;
                        throw throwable;
                    }
                    sleep += 500L;
                } while (!deleted && sleep < 5000L);
                return deleted;
            }
        };
    }

    public static DeleteResourceJob createDeleteResourceJob(IResource resource) {
        if (resource instanceof IProject) {
            return OpenShiftJobs.createDeleteProjectJob((IProject)resource);
        }
        return new DeleteResourceJob(resource);
    }
}

