/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.core.connection.IOpenShiftConnection;
import org.jboss.tools.openshift.internal.core.WatchManager;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.models.AbstractOpenshiftUIElement;
import org.jboss.tools.openshift.internal.ui.models.IConnectionWrapper;
import org.jboss.tools.openshift.internal.ui.models.IExceptionHandler;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.LoadingState;
import org.jboss.tools.openshift.internal.ui.models.OpenshiftUIModel;
import org.jboss.tools.openshift.internal.ui.models.ProjectWrapper;
import org.jboss.tools.openshift.internal.ui.models.ResourceCache;

public class ConnectionWrapper
extends AbstractOpenshiftUIElement<IOpenShiftConnection, OpenshiftUIModel>
implements IConnectionWrapper {
    public static final String[] RESOURCE_KINDS = new String[]{"Build", "BuildConfig", "DeploymentConfig", "Event", "ImageStream", "ImageStreamTag", "Pod", "Route", "ReplicationController", "Service", "Template", "PersistentVolumeClaim", "Project"};
    private AtomicReference<LoadingState> state = new AtomicReference<LoadingState>(LoadingState.INIT);
    private Map<String, ProjectWrapper> projects = new HashMap<String, ProjectWrapper>();
    private ResourceCache resourceCache = new ResourceCache();

    public ConnectionWrapper(OpenshiftUIModel parent, IOpenShiftConnection wrapped) {
        super(parent, wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IResourceWrapper<?, ?>> getResources() {
        Map<String, ProjectWrapper> map = this.projects;
        synchronized (map) {
            return new ArrayList(this.projects.values());
        }
    }

    @Override
    public Collection<IResourceWrapper<?, ?>> getResourcesOfKind(String kind) {
        if (!"Project".equals(kind)) {
            return Collections.emptyList();
        }
        return this.getResources();
    }

    @Override
    public <T extends IResourceWrapper<?, ?>> Collection<T> getResourcesOfType(Class<T> clazz) {
        ArrayList result = new ArrayList();
        for (IResourceWrapper<?, ?> r : this.getResources()) {
            if (!clazz.isInstance(r)) continue;
            result.add(r);
        }
        return result;
    }

    @Override
    public LoadingState getState() {
        return this.state.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initWith(List<IProject> resources) {
        Map<String, ProjectWrapper> map = this.projects;
        synchronized (map) {
            resources.forEach(project -> this.projects.put(project.getName(), new ProjectWrapper(this, (IProject)project)));
        }
        this.state.set(LoadingState.LOADED);
    }

    @Override
    public boolean load(IExceptionHandler handler) {
        if (this.state.compareAndSet(LoadingState.INIT, LoadingState.LOADING)) {
            this.startLoadJob((IOpenShiftConnection)this.getWrapped(), handler);
            return true;
        }
        return false;
    }

    void startLoadJob(final ProjectWrapper projectWrapper, final IExceptionHandler handler) {
        new Job(NLS.bind((String)"Loading OpenShift project {0}...", (Object)((IProject)projectWrapper.getWrapped()).getName())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject project = (IProject)projectWrapper.getWrapped();
                    IOpenShiftConnection connection = (IOpenShiftConnection)((ConnectionWrapper)projectWrapper.getParent()).getWrapped();
                    WatchManager.getInstance().startWatch(project, connection);
                    HashSet<IResource> resources = new HashSet<IResource>();
                    String[] stringArray = RESOURCE_KINDS;
                    int n = RESOURCE_KINDS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String kind = stringArray[n2];
                        resources.addAll(((IOpenShiftConnection)ConnectionWrapper.this.getWrapped()).getResources(kind, project.getNamespace()));
                        ++n2;
                    }
                    resources.forEach(r -> {
                        boolean bl = ConnectionWrapper.this.resourceCache.add((IResource)r);
                    });
                    projectWrapper.initWithResources(resources);
                    projectWrapper.fireChanged();
                }
                catch (OperationCanceledException operationCanceledException) {
                    projectWrapper.setLoadingState(LoadingState.LOAD_STOPPED);
                }
                catch (Throwable e) {
                    projectWrapper.setLoadingState(LoadingState.LOAD_STOPPED);
                    handler.handleException(e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void startLoadJob(final IOpenShiftConnection connection, final IExceptionHandler handler) {
        new Job(NLS.bind((String)"Loading OpenShift server {0}...", (Object)connection.getHost())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    List projects = connection.getResources("Project");
                    ConnectionWrapper.this.initWith(projects);
                    ConnectionWrapper.this.state.compareAndSet(LoadingState.LOADING, LoadingState.LOADED);
                    ConnectionWrapper.this.fireChanged();
                }
                catch (OperationCanceledException operationCanceledException) {
                    ConnectionWrapper.this.state.compareAndSet(LoadingState.LOADING, LoadingState.LOAD_STOPPED);
                }
                catch (Throwable e) {
                    ConnectionWrapper.this.state.compareAndSet(LoadingState.LOADING, LoadingState.LOAD_STOPPED);
                    handler.handleException(e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    void connectionChanged(String property, Object oldValue, Object newValue) {
        if ("openshift.resource".equals(property)) {
            if (newValue != null) {
                IResource newResource = (IResource)newValue;
                ProjectWrapper projectWrapper = this.findProjectWrapper(newResource);
                if (projectWrapper != null) {
                    if (((IProject)projectWrapper.getWrapped()).equals(newResource)) {
                        projectWrapper.updateWith((IResource)((IProject)newResource));
                    } else {
                        IResource oldVersion = this.resourceCache.getCachedVersion(newResource);
                        if (oldVersion == null) {
                            this.handleAdd(projectWrapper, newResource);
                        } else if (ResourceUtils.isOlder((IResource)oldVersion, (IResource)newResource)) {
                            this.handleUpdate(projectWrapper, newResource);
                        }
                    }
                } else if (oldValue != null) {
                    this.resourceCache.remove((IResource)oldValue);
                }
            } else if (oldValue != null) {
                IResource oldResource = this.resourceCache.getCachedVersion((IResource)oldValue);
                if (oldResource != null) {
                    ProjectWrapper projectWrapper = this.findProjectWrapper(oldResource);
                    this.handleRemove(projectWrapper, oldResource);
                }
            } else {
                OpenShiftUIActivator.log(2, "old and new value are null", new RuntimeException("Warning origing"));
            }
        } else if ("openshift.projects".equals(property) && newValue instanceof List) {
            this.updateWithResources((List)newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectWrapper findProjectWrapper(IResource resource) {
        Map<String, ProjectWrapper> map = this.projects;
        synchronized (map) {
            return this.projects.get(resource.getNamespace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWithResources(List<IProject> newValue) {
        HashMap<IProject, ProjectWrapper> updated = new HashMap<IProject, ProjectWrapper>();
        boolean changed = false;
        Map<String, ProjectWrapper> map = this.projects;
        synchronized (map) {
            HashMap<String, ProjectWrapper> oldWrappers = new HashMap<String, ProjectWrapper>(this.projects);
            this.projects.clear();
            for (IProject r2 : newValue) {
                ProjectWrapper existingWrapper = oldWrappers.remove(r2.getName());
                if (existingWrapper == null) {
                    ProjectWrapper newWrapper = new ProjectWrapper(this, r2);
                    this.resourceCache.add((IResource)r2);
                    this.projects.put(r2.getName(), newWrapper);
                    changed = true;
                    continue;
                }
                this.projects.put(r2.getName(), existingWrapper);
                updated.put(r2, existingWrapper);
            }
            if (!oldWrappers.isEmpty()) {
                changed = true;
            }
        }
        updated.keySet().forEach(r -> {
            ProjectWrapper wrapper = (ProjectWrapper)updated.get(r);
            wrapper.updateWith((IResource)r);
        });
        if (changed) {
            this.fireChanged();
        }
    }

    protected void handleAdd(ProjectWrapper projectWrapper, IResource newResource) {
        this.resourceCache.add(newResource);
        Collection<IResource> resources = this.resourceCache.getResources(newResource.getProject().getNamespace());
        projectWrapper.updateWithResources(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRemove(ProjectWrapper projectWrapper, IResource oldResource) {
        this.resourceCache.remove(oldResource);
        if (oldResource instanceof IProject) {
            Map<String, ProjectWrapper> map = this.projects;
            synchronized (map) {
                this.projects.remove(oldResource.getName());
                this.resourceCache.flush(oldResource.getName());
                this.fireChanged();
            }
        } else if (projectWrapper != null) {
            Collection<IResource> resources = this.resourceCache.getResources(oldResource.getNamespace());
            projectWrapper.updateWithResources(resources);
        }
    }

    protected void handleUpdate(ProjectWrapper projectWrapper, IResource newResource) {
        this.resourceCache.remove(newResource);
        this.resourceCache.add(newResource);
        Collection<IResource> resources = this.resourceCache.getResources(newResource.getNamespace());
        projectWrapper.updateWithResources(resources);
    }

    @Override
    public void refresh() {
        this.updateWithResources(this.loadProjects());
        this.state.set(LoadingState.LOADED);
        this.fireChanged();
        for (ProjectWrapper project : this.projects.values()) {
            project.refresh();
        }
    }

    private List<IProject> loadProjects() {
        return ((IOpenShiftConnection)this.getWrapped()).getResources("Project");
    }

    void refresh(ProjectWrapper projectWrapper) {
        this.resourceCache.flush(((IProject)projectWrapper.getWrapped()).getNamespace());
        IProject project = (IProject)projectWrapper.getWrapped();
        IOpenShiftConnection connection = (IOpenShiftConnection)((ConnectionWrapper)projectWrapper.getParent()).getWrapped();
        WatchManager.getInstance().stopWatch(project, connection);
        WatchManager.getInstance().startWatch(project, connection);
        HashSet<IResource> resources = new HashSet<IResource>();
        String[] stringArray = RESOURCE_KINDS;
        int n = RESOURCE_KINDS.length;
        int n2 = 0;
        while (n2 < n) {
            String kind = stringArray[n2];
            resources.addAll(((IOpenShiftConnection)this.getWrapped()).getResources(kind, project.getNamespace()));
            ++n2;
        }
        resources.forEach(r -> {
            boolean bl = this.resourceCache.add((IResource)r);
        });
        projectWrapper.updateWithResources(resources);
    }
}

