/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.IOpenShiftConnection;
import org.jboss.tools.openshift.internal.ui.models.AbstractOpenshiftUIElement;
import org.jboss.tools.openshift.internal.ui.models.ConnectionWrapper;
import org.jboss.tools.openshift.internal.ui.models.IElementListener;
import org.jboss.tools.openshift.internal.ui.models.IOpenshiftUIElement;

public class OpenshiftUIModel
extends AbstractOpenshiftUIElement<ConnectionsRegistry, OpenshiftUIModel> {
    private Map<IOpenShiftConnection, ConnectionWrapper> connections = new HashMap<IOpenShiftConnection, ConnectionWrapper>();
    private List<IElementListener> listeners = new ArrayList<IElementListener>();
    private IConnectionsRegistryListener listener = new IConnectionsRegistryListener(){

        public void connectionRemoved(IConnection connection) {
            OpenshiftUIModel.this.removeConnection(connection);
            OpenshiftUIModel.this.fireChanged(OpenshiftUIModel.this);
        }

        public void connectionChanged(IConnection c, String property, Object oldValue, Object newValue) {
            ConnectionWrapper connection = (ConnectionWrapper)OpenshiftUIModel.this.connections.get(c);
            if (connection == null) {
                return;
            }
            connection.connectionChanged(property, oldValue, newValue);
        }

        public void connectionAdded(IConnection connection) {
            if (!(connection instanceof IOpenShiftConnection)) {
                return;
            }
            OpenshiftUIModel.this.addConnection(connection);
            OpenshiftUIModel.this.fireChanged(OpenshiftUIModel.this);
        }
    };

    public static OpenshiftUIModel getInstance() {
        return OpenshiftUIModelSingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenshiftUIModel(ConnectionsRegistry registry) {
        super(null, registry);
        Collection allConnections = registry.getAll(Connection.class);
        Map<IOpenShiftConnection, ConnectionWrapper> map = this.connections;
        synchronized (map) {
            for (IConnection connection : allConnections) {
                if (!(connection instanceof IOpenShiftConnection)) continue;
                this.connections.put((IOpenShiftConnection)connection, new ConnectionWrapper(this, (IOpenShiftConnection)connection));
            }
        }
        registry.addListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(IConnection connection) {
        Map<IOpenShiftConnection, ConnectionWrapper> map = this.connections;
        synchronized (map) {
            if (this.connections.containsKey(connection)) {
                return;
            }
            this.connections.put((IOpenShiftConnection)connection, new ConnectionWrapper(this, (IOpenShiftConnection)connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(IConnection connection) {
        Map<IOpenShiftConnection, ConnectionWrapper> map = this.connections;
        synchronized (map) {
            this.connections.remove(connection);
        }
    }

    @Override
    protected void fireChanged(final IOpenshiftUIElement<?, ?> source) {
        if (Display.getCurrent() != null) {
            this.dispatchChange(source);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OpenshiftUIModel.this.dispatchChange(source);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchChange(IOpenshiftUIElement<?, ?> source) {
        ArrayList<IElementListener> copy = new ArrayList<IElementListener>();
        List<IElementListener> list = this.listeners;
        synchronized (list) {
            copy.addAll(this.listeners);
        }
        copy.forEach(l -> l.elementChanged(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IElementListener l) {
        List<IElementListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IElementListener l) {
        List<IElementListener> list = this.listeners;
        synchronized (list) {
            int lastIndex = this.listeners.lastIndexOf(l);
            if (lastIndex >= 0) {
                this.listeners.remove(lastIndex);
            }
        }
    }

    @Override
    public OpenshiftUIModel getRoot() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ConnectionWrapper> getConnections() {
        Map<IOpenShiftConnection, ConnectionWrapper> map = this.connections;
        synchronized (map) {
            return new ArrayList<ConnectionWrapper>(this.connections.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper getConnectionWrapperForConnection(IConnection connection) {
        Map<IOpenShiftConnection, ConnectionWrapper> map = this.connections;
        synchronized (map) {
            return this.connections.get(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        HashMap<IOpenShiftConnection, ConnectionWrapper> updated = new HashMap<IOpenShiftConnection, ConnectionWrapper>();
        boolean changed = false;
        Map<IOpenShiftConnection, ConnectionWrapper> map = this.connections;
        synchronized (map) {
            HashMap<IOpenShiftConnection, ConnectionWrapper> oldWrappers = new HashMap<IOpenShiftConnection, ConnectionWrapper>(this.connections);
            this.connections.clear();
            for (IOpenShiftConnection connection : ConnectionsRegistrySingleton.getInstance().getAll(IOpenShiftConnection.class)) {
                ConnectionWrapper existingWrapper = oldWrappers.remove(connection);
                if (existingWrapper == null) {
                    ConnectionWrapper newWrapper = new ConnectionWrapper(this, connection);
                    this.connections.put(connection, newWrapper);
                    changed = true;
                    continue;
                }
                this.connections.put(connection, existingWrapper);
                updated.put(connection, existingWrapper);
            }
            if (!oldWrappers.isEmpty()) {
                changed = true;
            }
        }
        if (changed) {
            this.fireChanged(this);
        }
        updated.keySet().forEach(r -> {
            ConnectionWrapper wrapper = (ConnectionWrapper)updated.get(r);
            wrapper.updateWith(r);
        });
        for (ConnectionWrapper connection : this.getConnections()) {
            connection.refresh();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    protected static class OpenshiftUIModelSingletonHolder {
        public static final OpenshiftUIModel INSTANCE = new OpenshiftUIModel(ConnectionsRegistrySingleton.getInstance());

        protected OpenshiftUIModelSingletonHolder() {
        }
    }
}

