/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.tools.openshift.internal.ui.models.AbstractResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.ConnectionWrapper;
import org.jboss.tools.openshift.internal.ui.models.IExceptionHandler;
import org.jboss.tools.openshift.internal.ui.models.IProjectWrapper;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.LoadingState;
import org.jboss.tools.openshift.internal.ui.models.ReplicationControllerWrapper;
import org.jboss.tools.openshift.internal.ui.models.ResourceContainer;
import org.jboss.tools.openshift.internal.ui.models.ResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.ServiceResourceMapper;
import org.jboss.tools.openshift.internal.ui.models.ServiceWrapper;

public class ProjectWrapper
extends ResourceContainer<IProject, ConnectionWrapper>
implements IProjectWrapper {
    private AtomicReference<LoadingState> state = new AtomicReference<LoadingState>(LoadingState.INIT);

    public ProjectWrapper(ConnectionWrapper parent, IProject resource) {
        super(parent, resource);
    }

    @Override
    public LoadingState getState() {
        return this.state.get();
    }

    void setLoadingState(LoadingState newState) {
        this.state.set(newState);
    }

    @Override
    public boolean load(IExceptionHandler handler) {
        if (this.state.compareAndSet(LoadingState.INIT, LoadingState.LOADING)) {
            ((ConnectionWrapper)this.getParent()).startLoadJob(this, handler);
            return true;
        }
        return false;
    }

    @Override
    protected void postUpdate(Collection<IResource> resources, Map<IResource, AbstractResourceWrapper<?, ?>> updated, boolean changed) {
        if (changed || !updated.isEmpty()) {
            this.getResources().forEach(wrapper -> {
                if (wrapper instanceof ServiceWrapper) {
                    ServiceWrapper service = (ServiceWrapper)wrapper;
                    Collection<IResource> relatedResources = ServiceResourceMapper.computeRelatedResources((IService)service.getWrapped(), resources);
                    service.updateWithResources(relatedResources);
                } else if (wrapper instanceof ReplicationControllerWrapper) {
                    ReplicationControllerWrapper dcWrapper = (ReplicationControllerWrapper)wrapper;
                    Collection<IResource> relatedresources = this.getRelatedResources(resources, (IResourceWrapper<?, ?>)wrapper);
                    dcWrapper.updateWithResources(relatedresources);
                }
            });
        }
    }

    private Collection<IResource> getRelatedResources(Collection<IResource> resources, IResourceWrapper<?, ?> wrapper) {
        Collection<IResource> relatedresources = "DeploymentConfig".equals(((IResource)wrapper.getWrapped()).getKind()) ? ServiceResourceMapper.computeRelatedResources((IDeploymentConfig)wrapper.getWrapped(), resources) : ServiceResourceMapper.computeRelatedResources((IReplicationController)wrapper.getWrapped(), resources);
        return relatedresources;
    }

    @Override
    protected AbstractResourceWrapper<?, ?> createNewWrapper(Collection<IResource> resources, IResource r) {
        AbstractResourceWrapper newWrapper;
        if (r instanceof IService) {
            ServiceWrapper newService = new ServiceWrapper(this, (IService)r);
            Collection<IResource> relatedResources = ServiceResourceMapper.computeRelatedResources((IService)r, resources);
            newService.initWithResources(relatedResources);
            newWrapper = newService;
        } else if (("DeploymentConfig".equals(r.getKind()) || "ReplicationController".equals(r.getKind()) && !r.isAnnotatedWith("openshift.io/deployment-config.name")) && ServiceResourceMapper.getServices((IReplicationController)r, resources).isEmpty()) {
            ReplicationControllerWrapper dcWrapper = new ReplicationControllerWrapper(this, (IReplicationController)r);
            Collection<IResource> relatedResource = this.getRelatedResources(resources, dcWrapper);
            dcWrapper.initWithResources(relatedResource);
            newWrapper = dcWrapper;
        } else {
            newWrapper = new ResourceWrapper(this, r);
        }
        return newWrapper;
    }

    @Override
    void initWithResources(Collection<IResource> resources) {
        super.initWithResources(resources);
        this.state.set(LoadingState.LOADED);
    }

    @Override
    public void refresh() {
        ((ConnectionWrapper)this.getParent()).refresh(this);
        this.state.set(LoadingState.LOADED);
        this.fireChanged();
    }

    @Override
    public Collection<IResourceWrapper<?, ?>> getResources() {
        this.load(IExceptionHandler.NULL_HANDLER);
        return super.getResources();
    }
}

