/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.tools.openshift.internal.ui.models.AbstractOpenshiftUIElement;
import org.jboss.tools.openshift.internal.ui.models.AbstractResourceWrapper;
import org.jboss.tools.openshift.internal.ui.models.IResourceContainer;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;

abstract class ResourceContainer<R extends IResource, P extends AbstractOpenshiftUIElement<?, ?>>
extends AbstractResourceWrapper<R, P>
implements IResourceContainer<R, P> {
    private Map<IResource, AbstractResourceWrapper<?, ?>> containedResources = new HashMap();
    private Object childrenLock = new Object();

    public ResourceContainer(P parent, R resource) {
        super(parent, resource);
    }

    @Override
    public Collection<IResourceWrapper<?, ?>> getResourcesOfKind(String kind) {
        return this.getResources().stream().filter(wrapper -> ((IResource)wrapper.getWrapped()).getKind().equals(kind)).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IResourceWrapper<?, ?>> getResources() {
        Object object = this.childrenLock;
        synchronized (object) {
            return new ArrayList(this.containedResources.values());
        }
    }

    @Override
    public <T extends IResourceWrapper<?, ?>> Collection<T> getResourcesOfType(Class<T> clazz) {
        ArrayList result = new ArrayList();
        for (IResourceWrapper<?, ?> r : this.getResources()) {
            if (!clazz.isInstance(r)) continue;
            result.add(r);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateWithResources(Collection<IResource> resources) {
        HashMap updated = new HashMap();
        boolean changed = false;
        Object object = this.childrenLock;
        synchronized (object) {
            HashMap oldWrappers = new HashMap(this.containedResources);
            this.containedResources.clear();
            for (IResource r2 : resources) {
                AbstractResourceWrapper<?, ?> existingWrapper = oldWrappers.remove(r2);
                if (existingWrapper == null) {
                    AbstractResourceWrapper<?, ?> newWrapper = this.createNewWrapper(resources, r2);
                    this.containedResources.put(r2, newWrapper);
                    changed = true;
                    continue;
                }
                this.containedResources.put(r2, existingWrapper);
                updated.put(r2, existingWrapper);
            }
            if (!oldWrappers.isEmpty()) {
                changed = true;
            }
        }
        if (changed) {
            this.fireChanged();
        }
        updated.keySet().forEach(r -> {
            AbstractResourceWrapper wrapper = (AbstractResourceWrapper)updated.get(r);
            wrapper.updateWith((IResource)r);
        });
        this.postUpdate(resources, updated, changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initWithResources(Collection<IResource> resources) {
        Object object = this.childrenLock;
        synchronized (object) {
            resources.forEach(r -> this.containedResources.put((IResource)r, this.createNewWrapper(resources, (IResource)r)));
        }
    }

    protected abstract void postUpdate(Collection<IResource> var1, Map<IResource, AbstractResourceWrapper<?, ?>> var2, boolean var3);

    protected abstract AbstractResourceWrapper<?, ?> createNewWrapper(Collection<IResource> var1, IResource var2);
}

