/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.models;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.deploy.IDeploymentImageChangeTrigger;
import com.openshift.restclient.model.route.IRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;

public class ServiceResourceMapper {
    public static final Collection<IResource> computeRelatedResources(IService s, Collection<IResource> resources) {
        HashSet<IResource> result = new HashSet<IResource>();
        resources.forEach(resource -> {
            if (resource instanceof IPod) {
                if (ResourceUtils.areRelated((IPod)((IPod)resource), (IService)s)) {
                    result.add((IResource)resource);
                    result.addAll(ServiceResourceMapper.getRelated(resources, (IPod)resource));
                }
            } else if (resource instanceof IDeploymentConfig) {
                if (ResourceUtils.areRelated((IDeploymentConfig)((IDeploymentConfig)resource), (IService)s)) {
                    result.add((IResource)resource);
                    result.addAll(ServiceResourceMapper.getRelated(resources, (IDeploymentConfig)resource));
                }
            } else if (resource instanceof IRoute && ResourceUtils.areRelated((IRoute)((IRoute)resource), (IService)s)) {
                result.add((IResource)resource);
            }
        });
        return result;
    }

    public static final Collection<IResource> computeRelatedResources(IDeploymentConfig dc, Collection<IResource> resources) {
        return ServiceResourceMapper.getRelated(resources, dc);
    }

    public static final Collection<IResource> computeRelatedResources(IReplicationController rc, Collection<IResource> resources) {
        ArrayList<IResource> pods = new ArrayList<IResource>();
        pods.addAll(ServiceResourceMapper.getRelatedPods(resources, rc));
        return pods;
    }

    private static Collection<IResource> getRelated(Collection<IResource> resources, IPod resource) {
        return ServiceResourceMapper.getRelatedReplicationControllers(resources, Collections.singleton(resource));
    }

    private static Collection<IResource> getRelated(Collection<IResource> resources, IDeploymentConfig dc) {
        HashSet<IResource> result = new HashSet<IResource>();
        Collection<String> dcImageRefs = ServiceResourceMapper.computeImageRefs(dc);
        result.addAll(ServiceResourceMapper.getRelatedImageTags(resources, dcImageRefs, dc));
        Collection<IBuildConfig> buildConfigs = ServiceResourceMapper.getRelatedBuildConfigs(resources, dcImageRefs, dc);
        result.addAll(buildConfigs);
        Collection<IBuild> builds = ServiceResourceMapper.getRelatedBuilds(resources, dcImageRefs, buildConfigs);
        result.addAll(builds);
        Collection<IPod> pods = ServiceResourceMapper.getRelatedPods(resources, builds, dc);
        result.addAll(pods);
        result.addAll(ServiceResourceMapper.getRelatedReplicationControllers(resources, pods));
        result.addAll(ServiceResourceMapper.getRelatedReplicationControllers(resources, dc));
        return result;
    }

    private static Collection<IResource> getRelatedReplicationControllers(Collection<IResource> resources, IDeploymentConfig dc) {
        return resources.stream().filter(r -> dc.getName().equals(r.getAnnotation("openshift.io/deployment-config.name"))).collect(Collectors.toList());
    }

    private static Collection<IResource> getRelatedReplicationControllers(Collection<IResource> resources, Collection<IPod> pods) {
        Collection deploymentNames = pods.stream().filter(r -> r.isAnnotatedWith("openshift.io/deployment.name")).map(r -> r.getAnnotation("openshift.io/deployment.name")).collect(Collectors.toSet());
        HashSet<IResource> result = new HashSet<IResource>();
        resources.forEach(r -> {
            if ("ReplicationController".equals(r.getKind()) && deploymentNames.contains(r.getName())) {
                result.add((IResource)r);
            }
        });
        return result;
    }

    private static Collection<IPod> getRelatedPods(Collection<IResource> resources, Collection<IBuild> builds, IDeploymentConfig dc) {
        Collection buildNames = builds.stream().map(bc -> bc.getName()).collect(Collectors.toSet());
        return resources.stream().filter(r -> r instanceof IPod && (buildNames.contains(r.getAnnotation("openshift.io/build.name")) || dc.getName().equals(r.getAnnotation("openshift.io/deployment-config.name")))).map(r -> (IPod)r).collect(Collectors.toSet());
    }

    private static Collection<IPod> getRelatedPods(Collection<IResource> resources, IReplicationController rc) {
        return resources.stream().filter(r -> r instanceof IPod && ResourceUtils.areRelated((IPod)((IPod)r), (IReplicationController)rc)).map(r -> (IPod)r).collect(Collectors.toSet());
    }

    private static Collection<IBuild> getRelatedBuilds(Collection<IResource> resources, Collection<String> dcImageRefs, Collection<IBuildConfig> buildConfigs) {
        HashSet<IBuild> result = new HashSet<IBuild>();
        Collection bcNames = buildConfigs.stream().map(bc -> bc.getName()).collect(Collectors.toSet());
        resources.forEach(r -> {
            if (r instanceof IBuild) {
                IBuild build = (IBuild)r;
                if (bcNames.contains(r.getLabels().get("openshift.io/build-config.name")) || dcImageRefs.contains(ResourceUtils.imageRef((IBuild)build))) {
                    result.add((IBuild)r);
                }
            }
        });
        return result;
    }

    private static Collection<IBuildConfig> getRelatedBuildConfigs(Collection<IResource> resources, Collection<String> dcImageRefs, IDeploymentConfig dc) {
        HashSet<IBuildConfig> result = new HashSet<IBuildConfig>();
        resources.forEach(r -> {
            if (r instanceof IBuildConfig && dcImageRefs.contains(ResourceUtils.imageRef((IBuildConfig)((IBuildConfig)r)))) {
                result.add((IBuildConfig)r);
            }
        });
        return result;
    }

    private static Collection<IResource> getRelatedImageTags(Collection<IResource> resources, Collection<String> dcImageRefs, IDeploymentConfig dc) {
        HashSet<IResource> result = new HashSet<IResource>();
        resources.forEach(r -> {
            if ("ImageStreamTag".equals(r.getKind()) && dcImageRefs.contains(r.getName())) {
                result.add((IResource)r);
            }
        });
        return result;
    }

    public static Collection<String> computeImageRefs(IDeploymentConfig dc) {
        HashSet<String> imageRefs = new HashSet<String>(dc.getTriggers().size());
        dc.getTriggers().forEach(trigger -> {
            if ("ImageChange".equals(trigger.getType())) {
                imageRefs.add(ResourceUtils.imageRef((IDeploymentImageChangeTrigger)((IDeploymentImageChangeTrigger)trigger)));
            }
        });
        return imageRefs;
    }

    public static Collection<IResource> getServices(IReplicationController rc, Collection<IResource> resources) {
        return resources.stream().filter(r -> "Service".equals(r.getKind())).filter(s -> ResourceUtils.areRelated((IReplicationController)rc, (IService)((IService)s))).collect(Collectors.toList());
    }
}

