/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.portforwading;

import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.model.IPod;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.internal.common.ui.console.ConsoleUtils;
import org.jboss.tools.openshift.internal.core.portforwarding.PortForwardingUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class PortForwardingWizardModel
extends ObservablePojo {
    public static final String PROPERTY_FORWARDABLE_PORTS = "forwardablePorts";
    public static final String PROPERTY_PORT_FORWARDING = "portForwarding";
    public static final String PROPERTY_PORT_FORWARDING_ALLOWED = "portForwardingAllowed";
    public static final String PROPERTY_FREE_PORT_SEARCH_ALLOWED = "freePortSearchAllowed";
    public static final String PROPERTY_USE_FREE_PORTS = "useFreePorts";
    private Boolean useFreePorts = Boolean.FALSE;
    private final IPod pod;
    private final ConsoleListener consoleListener = new ConsoleListener();
    private final Set<IPortForwardable.PortPair> ports;
    private boolean isPortForwardingAllowed = false;

    public PortForwardingWizardModel(IPod pod) {
        this.pod = pod;
        this.ports = PortForwardingUtils.getForwardablePorts((IPod)pod);
        this.useFreePorts = this.computeUsingFreePorts();
        this.updatePortForwardingAllowed();
    }

    public final String getPodName() {
        return String.valueOf(this.pod.getNamespace()) + "\\" + this.pod.getName();
    }

    public boolean getPortForwarding() {
        return PortForwardingUtils.isPortForwardingStarted((IPod)this.pod);
    }

    public boolean checkPortForwardingAllowed() {
        this.updatePortForwardingAllowed();
        return this.isPortForwardingAllowed();
    }

    public boolean isPortForwardingAllowed() {
        return this.isPortForwardingAllowed;
    }

    private void updatePortForwardingAllowed() {
        boolean newValue;
        this.isPortForwardingAllowed = newValue = !this.getForwardablePorts().isEmpty() && !PortForwardingUtils.isPortForwardingStarted((IPod)this.pod) && !PortForwardingUtils.hasPortInUse(this.ports);
        this.firePropertyChange(PROPERTY_PORT_FORWARDING_ALLOWED, this.isPortForwardingAllowed, this.isPortForwardingAllowed);
    }

    public boolean isFreePortSearchAllowed() {
        return !this.getForwardablePorts().isEmpty() && !PortForwardingUtils.isPortForwardingStarted((IPod)this.pod);
    }

    public Collection<IPortForwardable.PortPair> getForwardablePorts() {
        return this.ports;
    }

    public void startPortForwarding() {
        MessageConsole console = ConsoleUtils.findMessageConsole((String)this.getMessageConsoleName());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (MessageConsoleStream stream = console.newMessageStream();){
                ConsoleUtils.registerConsoleListener((IConsoleListener)this.consoleListener);
                ConsoleUtils.displayConsoleView((IConsole)console);
                stream.println("Starting port-forwarding...");
                IPortForwardable portForwardable = PortForwardingUtils.startPortForwarding((IPod)this.pod, this.ports, (IBinaryCapability.OpenShiftBinaryOption[])new IBinaryCapability.OpenShiftBinaryOption[]{IBinaryCapability.OpenShiftBinaryOption.SKIP_TLS_VERIFY});
                portForwardable.getPortPairs().stream().forEach(port -> stream.println(NLS.bind((String)"{0} {1} -> {2}", (Object[])new Object[]{port.getName(), port.getLocalPort(), port.getRemotePort()})));
                stream.println("done.");
                this.firePropertyChange(PROPERTY_PORT_FORWARDING, false, this.getPortForwarding());
                this.updatePortForwardingAllowed();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            OpenShiftUIActivator.getDefault().getLogger().logError("Error while closing the console inputstream", (Throwable)e);
        }
    }

    private String getMessageConsoleName() {
        return NLS.bind((String)"Port forwarding to pod {0} ({1})", (Object)this.pod.getName(), (Object)this.pod.getNamespace());
    }

    public void stopPortForwarding() throws IOException {
        if (!PortForwardingUtils.isPortForwardingStarted((IPod)this.pod)) {
            return;
        }
        MessageConsole console = ConsoleUtils.findMessageConsole((String)this.getMessageConsoleName());
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (MessageConsoleStream stream = console.newMessageStream();){
                stream.println("Stopping port-forwarding...");
                IPortForwardable cap = PortForwardingUtils.stopPortForwarding((IPod)this.pod, (OutputStream)stream);
                if (cap != null) {
                    cap.getPortPairs().stream().forEach(port -> stream.println(NLS.bind((String)"{0} {1} -> {2}", (Object[])new Object[]{port.getName(), port.getLocalPort(), port.getRemotePort()})));
                }
                if (!PortForwardingUtils.hasPortInUse(this.ports)) {
                    stream.println("done.");
                } else {
                    stream.println("Ports remain in use yet. Stopping ports is requested and eventually will be completed.");
                }
                ConsoleUtils.displayConsoleView((IConsole)console);
                this.firePropertyChange(PROPERTY_PORT_FORWARDING, true, this.getPortForwarding());
                this.updatePortForwardingAllowed();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            ConsoleUtils.deregisterConsoleListener((IConsoleListener)this.consoleListener);
        }
    }

    boolean waitForPortsToGetFree(int timeSeconds) {
        try {
            boolean result = timeSeconds == 0 ? !PortForwardingUtils.hasPortInUse(this.ports) : PortForwardingUtils.waitForPortsToGetFree(this.ports, (int)timeSeconds, (OutputStream)System.out);
            this.updatePortForwardingAllowed();
            return result;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Boolean getUseFreePorts() {
        return this.useFreePorts;
    }

    public void setUseFreePorts(Boolean useFreePorts) {
        if (!this.getPortForwarding()) {
            this.updateLocalPortBindings(useFreePorts);
        }
        this.useFreePorts = useFreePorts;
        this.firePropertyChange(PROPERTY_USE_FREE_PORTS, this.useFreePorts, this.useFreePorts);
    }

    private void updateLocalPortBindings(boolean useFreePorts) {
        ArrayList<String> bindings = new ArrayList<String>();
        for (IPortForwardable.PortPair port : this.ports) {
            if (useFreePorts) {
                port.setLocalPort(SocketUtil.findFreePort());
                continue;
            }
            port.setLocalPort(port.getRemotePort());
            String key = this.computeKey(port);
            while (bindings.contains(key)) {
                port.setLocalPort(SocketUtil.findFreePort());
                key = this.computeKey(port);
            }
            bindings.add(key);
        }
        this.updatePortForwardingAllowed();
    }

    private boolean computeUsingFreePorts() {
        if (this.ports.isEmpty() || !PortForwardingUtils.isPortForwardingStarted((IPod)this.pod)) {
            return false;
        }
        for (IPortForwardable.PortPair port : this.ports) {
            if (port.getLocalPort() != port.getRemotePort()) continue;
            return false;
        }
        return true;
    }

    private String computeKey(IPortForwardable.PortPair port) {
        return "127.0.0.1:" + port.getLocalPort();
    }

    private class ConsoleListener
    implements IConsoleListener {
        private ConsoleListener() {
        }

        public void consolesRemoved(IConsole[] consoles) {
            String messageConsoleName = PortForwardingWizardModel.this.getMessageConsoleName();
            if (Stream.of(consoles).filter(console -> console.getName().equals(messageConsoleName)).findAny().isPresent()) {
                try {
                    try {
                        PortForwardingUtils.stopPortForwarding((IPod)PortForwardingWizardModel.this.pod, null);
                    }
                    catch (IOException iOException) {
                        ConsoleUtils.deregisterConsoleListener((IConsoleListener)this);
                    }
                }
                finally {
                    ConsoleUtils.deregisterConsoleListener((IConsoleListener)this);
                }
            }
        }

        public void consolesAdded(IConsole[] consoles) {
        }
    }
}

