/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.preferences;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.common.core.connection.HostCertificate;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.utils.SSLCertificateUtils;

public class SSLCertificatesPreference {
    private static final String SEPARATOR = ";";
    private static final String ALLOWED_CERTIFICATES = "allowed_certificates";
    private static final String ALLOWED_CERTIFICATES_NEW = "allowed_certificates_new";
    private static final SSLCertificatesPreference INSTANCE = new SSLCertificatesPreference();
    private List<HostCertificate> savedItems = null;

    protected SSLCertificatesPreference() {
    }

    public static SSLCertificatesPreference getInstance() {
        return INSTANCE;
    }

    public CertificateState isAllowed(X509Certificate certificate) {
        HostCertificate lookedUp = new HostCertificate(false, certificate);
        HostCertificate found = this.findCertificate(this.getSavedCertificates(), lookedUp);
        if (found == null) {
            return CertificateState.NOT_PRESENT;
        }
        if (found.isAccepted()) {
            return CertificateState.ACCEPTED;
        }
        return CertificateState.REJECTED;
    }

    public void addOrReplaceCertificate(X509Certificate certificate, boolean accepted) {
        HostCertificate newCertificate = new HostCertificate(accepted, certificate);
        List<HostCertificate> savedItems = this.getSavedCertificates();
        HostCertificate item = this.findCertificate(savedItems, newCertificate);
        if (item == null) {
            savedItems.add(newCertificate);
        } else {
            item.setAccepted(accepted);
        }
        this.saveToPreference(savedItems);
    }

    public synchronized List<HostCertificate> getSavedCertificates() {
        if (this.savedItems == null) {
            this.savedItems = this.loadSavedCertificates();
        }
        return this.savedItems;
    }

    private synchronized List<HostCertificate> loadSavedCertificates() {
        ArrayList<HostCertificate> savedItems = new ArrayList<HostCertificate>();
        String value = this.getPreferenceStore().getString(ALLOWED_CERTIFICATES_NEW);
        if (!StringUtils.isBlank((String)value)) {
            String[] tokens = value.split(SEPARATOR);
            int i = 0;
            while (i + 2 <= tokens.length) {
                HostCertificate hostCertificate;
                X509Certificate certificate;
                boolean accepted = Boolean.toString(Boolean.TRUE).equals(tokens[i++]);
                if ((certificate = this.createCertificate(tokens[i++])) == null || !(hostCertificate = new HostCertificate(accepted, certificate)).isValid()) continue;
                savedItems.add(hostCertificate);
            }
        }
        return savedItems;
    }

    protected X509Certificate createCertificate(String certificateString) {
        try {
            return SSLCertificateUtils.createX509Certificate(certificateString);
        }
        catch (CertificateException certificateException) {
            IStatus status = StatusFactory.errorStatus((String)"org.jboss.tools.openshift.ui", (String)NLS.bind((String)"Could not read certificate for certificate {0}", (Object)StringUtils.abbreviate((String)certificateString, (int)50)));
            OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
            return null;
        }
    }

    private HostCertificate findCertificate(List<HostCertificate> existingCertificates, HostCertificate lookedUp) {
        if (existingCertificates == null || existingCertificates.isEmpty()) {
            return null;
        }
        return existingCertificates.stream().filter(existing -> existing.equals((Object)lookedUp)).findFirst().orElse(null);
    }

    public void save(Collection<HostCertificate> certificates) {
        List<HostCertificate> savedItems = this.getSavedCertificates();
        savedItems.clear();
        savedItems.addAll(certificates);
        this.saveToPreference(savedItems);
    }

    private synchronized void saveToPreference(List<HostCertificate> certificates) {
        String certificatesString = this.toString(certificates);
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(ALLOWED_CERTIFICATES_NEW, certificatesString);
        this.save(store);
    }

    private synchronized void save(IPreferenceStore store) {
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    private String toString(List<HostCertificate> certificates) {
        StringBuilder builder = new StringBuilder();
        certificates.stream().forEach(certificate -> {
            String base64Certificate = this.toPreferenceValue((HostCertificate)certificate);
            if (!StringUtils.isBlank((String)base64Certificate)) {
                builder.append(base64Certificate).append(SEPARATOR);
            }
        });
        return builder.toString();
    }

    private String toPreferenceValue(HostCertificate certificate) {
        try {
            return certificate.isAccepted() + SEPARATOR + SSLCertificateUtils.toString(certificate.getCertificate());
        }
        catch (CertificateEncodingException e) {
            OpenShiftUIActivator.getDefault().getLogger().logError(NLS.bind((String)"Could not encode certificate {0}", (Object)certificate.toString()), (Throwable)e);
            return null;
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return OpenShiftUIActivator.getDefault().getCorePreferenceStore();
    }

    public static enum CertificateState {
        ACCEPTED,
        REJECTED,
        NOT_PRESENT;

    }
}

