/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheet;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.core.ICommonAttributes;
import org.jboss.tools.openshift.core.connection.IOpenShiftConnection;
import org.jboss.tools.openshift.internal.common.ui.utils.OpenShiftUIUtils;
import org.jboss.tools.openshift.internal.ui.property.UneditablePropertyDescriptor;

public class ConnectionPropertySource
implements IPropertySource {
    private static final String HOST = "host";
    private static final String USERNAME = "username";
    private static final String OPENSHIFT_MASTER_VERSION = "openshift-version";
    private static final String KUBERNETES_MASTER_VERSION = "kubernetes-version";
    private IConnection connection;
    private ConnectionListener listener = new ConnectionListener();

    public ConnectionPropertySource(IConnection connection) {
        this.connection = connection;
        ConnectionsRegistrySingleton.getInstance().addListener((IConnectionsRegistryListener)this.listener);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<UneditablePropertyDescriptor> descriptors = new ArrayList<UneditablePropertyDescriptor>();
        descriptors.add(new UneditablePropertyDescriptor(HOST, "Host"));
        descriptors.add(new UneditablePropertyDescriptor(USERNAME, "User Name"));
        descriptors.add(new UneditablePropertyDescriptor(OPENSHIFT_MASTER_VERSION, "OpenShift Master Version"));
        descriptors.add(new UneditablePropertyDescriptor(KUBERNETES_MASTER_VERSION, "Kubernetes Master Version"));
        if (this.connection instanceof IOpenShiftConnection) {
            TreeSet set = new TreeSet(((IOpenShiftConnection)this.connection).getExtendedProperties().keySet());
            for (String name : set) {
                descriptors.add(new UneditablePropertyDescriptor(name, this.toVisualPropertyName(name)));
            }
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    private String toVisualPropertyName(String name) {
        String label = (String)ICommonAttributes.EXTENDED_PROPERTY_LABELS.get(name);
        if (label != null) {
            return label;
        }
        if (name.length() > 1) {
            return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        return name;
    }

    public Object getPropertyValue(Object id) {
        if (id == null) {
            return null;
        }
        if (HOST.equals(id)) {
            return this.connection.toString();
        }
        if (USERNAME.equals(id)) {
            return this.connection.getUsername();
        }
        if (this.connection instanceof IOpenShiftConnection) {
            IOpenShiftConnection openshiftConnection = (IOpenShiftConnection)this.connection;
            if (OPENSHIFT_MASTER_VERSION.equals(id)) {
                return openshiftConnection.getOpenShiftMasterVersion();
            }
            if (KUBERNETES_MASTER_VERSION.equals(id)) {
                return openshiftConnection.getKubernetesMasterVersion();
            }
            Object result = openshiftConnection.getExtendedProperties().get(id);
            return result == null ? "" : result.toString();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public void dispose() {
        ConnectionsRegistrySingleton.getInstance().removeListener((IConnectionsRegistryListener)this.listener);
    }

    class ConnectionListener
    implements IConnectionsRegistryListener {
        ConnectionListener() {
        }

        public void connectionAdded(IConnection connection) {
        }

        public void connectionRemoved(IConnection connection) {
        }

        public void connectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
            if (connection.equals(ConnectionPropertySource.this.connection) && "extendedProperties".equals(property)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PropertySheet sh = OpenShiftUIUtils.getPropertySheet();
                        if (sh != null) {
                            OpenShiftUIUtils.refreshPropertySheetPage((PropertySheet)sh);
                        }
                    }
                });
            }
        }
    }
}

