/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.IServicePort;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.openshift.internal.ui.models.IServiceWrapper;
import org.jboss.tools.openshift.internal.ui.property.ExtTextPropertyDescriptor;
import org.jboss.tools.openshift.internal.ui.property.UneditablePropertyDescriptor;

public class DeploymentPropertySource
implements IPropertySource {
    private IServiceWrapper deployment;

    public DeploymentPropertySource(IServiceWrapper deployment) {
        this.deployment = deployment;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new ExtTextPropertyDescriptor("service.name", "Name", "Service"), new ExtTextPropertyDescriptor("service.port", "Port Mapping", "Service"), new ExtTextPropertyDescriptor("service.route", "Route", "Service"), new ExtTextPropertyDescriptor("deployment.name", "Name", "Deployment"), new ExtTextPropertyDescriptor("deployment.date", "Date", "Deployment"), new UneditablePropertyDescriptor("pods", "Pods")};
    }

    public Object getPropertyValue(Object id) {
        switch ((String)id) {
            case "service.name": {
                return ((IService)this.deployment.getWrapped()).getName();
            }
            case "service.port": {
                List ports = ((IService)this.deployment.getWrapped()).getPorts();
                if (ports.size() <= 0) break;
                IServicePort port = (IServicePort)ports.get(0);
                return NLS.bind((String)"{0}/{1}->{2}", (Object[])new Object[]{port.getPort(), port.getProtocol(), port.getTargetPort()});
            }
            case "pods": 
            case "service.route": 
            case "deployment.date": 
            case "deployment.name": {
                return this.deployment.getResourcesOfKind("Pod").size();
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

