/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IEvent;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.openshift.internal.common.ui.utils.DateTimeUtils;
import org.jboss.tools.openshift.internal.ui.property.ResourcePropertySource;
import org.jboss.tools.openshift.internal.ui.property.UneditablePropertyDescriptor;

public class EventPropertySource
extends ResourcePropertySource<IEvent> {
    public EventPropertySource(IEvent resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new UneditablePropertyDescriptor("firstSeen", "First Seen"), new UneditablePropertyDescriptor("lastSeen", "Last Seen"), new UneditablePropertyDescriptor("count", "Count"), new UneditablePropertyDescriptor("name", "Name"), new UneditablePropertyDescriptor("kind", "Kind"), new UneditablePropertyDescriptor("subobject", "Subobject"), new UneditablePropertyDescriptor("type", "Type"), new UneditablePropertyDescriptor("reason", "Reason"), new UneditablePropertyDescriptor("source", "Source"), new UneditablePropertyDescriptor("message", "Message")};
    }

    @Override
    public Object getPropertyValue(Object id) {
        IEvent e = (IEvent)this.getResource();
        switch ((String)id) {
            case "firstSeen": {
                return DateTimeUtils.formatSince((String)e.getFirstSeenTimestamp());
            }
            case "lastSeen": {
                return DateTimeUtils.formatSince((String)e.getLastSeenTimestamp());
            }
            case "count": {
                return e.getCount();
            }
            case "name": {
                return StringUtils.substringBefore((String)e.getName(), (String)".");
            }
            case "kind": {
                return e.getKind();
            }
            case "type": {
                return e.getType();
            }
            case "reason": {
                return e.getReason();
            }
            case "source": {
                return e.getEventSource();
            }
            case "subobject": {
                return e.getInvolvedObject() != null ? e.getInvolvedObject().getFieldPath() : null;
            }
            case "message": {
                return e.getMessage();
            }
        }
        return super.getPropertyValue(id);
    }
}

