/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IPod;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.openshift.internal.ui.property.ResourcePropertySource;
import org.jboss.tools.openshift.internal.ui.property.UneditablePropertyDescriptor;

public class PodPropertySource
extends ResourcePropertySource<IPod> {
    public PodPropertySource(IPod resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getResourcePropertyDescriptors() {
        return new IPropertyDescriptor[]{new UneditablePropertyDescriptor("ip", "IP"), new UneditablePropertyDescriptor("host", "Host"), new UneditablePropertyDescriptor("images", "Image(s)"), new UneditablePropertyDescriptor("status", "Status")};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if ("status".equals(id)) {
            return ((IPod)this.getResource()).getStatus();
        }
        if ("ip".equals(id)) {
            return ((IPod)this.getResource()).getIP();
        }
        if ("host".equals(id)) {
            return ((IPod)this.getResource()).getHost();
        }
        if ("images".equals(id)) {
            return StringUtils.join((Collection)((IPod)this.getResource()).getImages(), (String)", ");
        }
        return super.getPropertyValue(id);
    }
}

