/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IReplicationController;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.openshift.internal.ui.property.ResourcePropertySource;
import org.jboss.tools.openshift.internal.ui.property.UneditablePropertyDescriptor;

public class ReplicationControllerPropertySource
extends ResourcePropertySource<IReplicationController> {
    public ReplicationControllerPropertySource(IReplicationController resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getResourcePropertyDescriptors() {
        return new IPropertyDescriptor[]{new UneditablePropertyDescriptor("replicas", "Replicas"), new UneditablePropertyDescriptor("selector", "Selector"), new UneditablePropertyDescriptor("images", "Image(s)")};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if ("replicas".equals(id)) {
            return String.format("%s current / %s desired", ((IReplicationController)this.getResource()).getCurrentReplicaCount(), ((IReplicationController)this.getResource()).getDesiredReplicaCount());
        }
        if ("selector".equals(id)) {
            return org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)((IReplicationController)this.getResource()).getReplicaSelector());
        }
        if ("images".equals(id)) {
            return StringUtils.join((Collection)((IReplicationController)this.getResource()).getImages(), (String)", ");
        }
        return super.getPropertyValue(id);
    }
}

