/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.openshift.internal.ui.property.ExtTextPropertyDescriptor;
import org.jboss.tools.openshift.internal.ui.property.PrefixPropertySourceKey;

public class ResourcePropertySource<T extends IResource>
implements IPropertySource {
    private static final String BASIC = "Basic";
    private static final String ANNOTATIONS = "Annotations";
    private static final String LABELS = "Labels";
    private T resource;

    public ResourcePropertySource(T resource) {
        this.resource = resource;
    }

    protected T getResource() {
        return this.resource;
    }

    protected IPropertyDescriptor[] getResourcePropertyDescriptors() {
        return new IPropertyDescriptor[0];
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> common = new ArrayList<IPropertyDescriptor>(Arrays.asList(new IPropertyDescriptor[]{new ExtTextPropertyDescriptor((Object)Ids.KIND, "Kind", BASIC), new ExtTextPropertyDescriptor((Object)Ids.NAME, "Name", BASIC), new ExtTextPropertyDescriptor((Object)Ids.NAMESPACE, "Namespace", BASIC), new ExtTextPropertyDescriptor((Object)Ids.CREATED, "Creation Timestamp", BASIC), new ExtTextPropertyDescriptor((Object)Ids.RESOURCE_VERSION, "Resource Version", BASIC)}));
        common.addAll(this.buildPropertyDescriptors(ANNOTATIONS, this.resource.getAnnotations()));
        common.addAll(this.buildPropertyDescriptors(LABELS, this.resource.getLabels()));
        common.addAll(Arrays.asList(this.getResourcePropertyDescriptors()));
        return common.toArray(new IPropertyDescriptor[common.size()]);
    }

    private List<IPropertyDescriptor> buildPropertyDescriptors(String prefix, Map<String, String> values) {
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>(values.size());
        for (Map.Entry<String, String> entry : values.entrySet()) {
            descriptors.add((IPropertyDescriptor)new ExtTextPropertyDescriptor(new PrefixPropertySourceKey(prefix, entry.getKey()), entry.getKey(), prefix));
        }
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof Ids) {
            Ids e = (Ids)((Object)id);
            switch (e) {
                case KIND: {
                    return this.resource.getKind();
                }
                case NAME: {
                    return this.resource.getName();
                }
                case NAMESPACE: {
                    return this.resource.getNamespace();
                }
                case CREATED: {
                    return this.resource.getCreationTimeStamp();
                }
                case RESOURCE_VERSION: {
                    return this.resource.getResourceVersion();
                }
            }
        }
        if (id instanceof PrefixPropertySourceKey) {
            PrefixPropertySourceKey key = (PrefixPropertySourceKey)id;
            String prefix = key.getPrefix();
            if (ANNOTATIONS.equals(prefix)) {
                return this.resource.getAnnotation(key.getKey());
            }
            if (LABELS.equals(prefix)) {
                return this.resource.getLabels().get(key.getKey());
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public static enum Ids {
        KIND,
        NAME,
        NAMESPACE,
        CREATED,
        RESOURCE_VERSION;

    }
}

