/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.volume.IPersistentVolumeClaim;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.openshift.internal.ui.property.ResourcePropertySource;
import org.jboss.tools.openshift.internal.ui.property.UneditablePropertyDescriptor;

public class StoragePropertySource
extends ResourcePropertySource<IPersistentVolumeClaim> {
    public StoragePropertySource(IPersistentVolumeClaim resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getResourcePropertyDescriptors() {
        return new IPropertyDescriptor[]{new UneditablePropertyDescriptor((Object)StorageIds.Modes, "Access Modes"), new UneditablePropertyDescriptor((Object)StorageIds.Requested, "Requested Capacity"), new UneditablePropertyDescriptor((Object)StorageIds.Status, "Status")};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id instanceof StorageIds) {
            StorageIds stId = (StorageIds)((Object)id);
            switch (stId) {
                case Modes: {
                    return String.join((CharSequence)", ", ((IPersistentVolumeClaim)this.getResource()).getAccessModes());
                }
                case Requested: {
                    return ((IPersistentVolumeClaim)this.getResource()).getRequestedStorage();
                }
                case Status: {
                    return this.getStatus();
                }
            }
        }
        return super.getPropertyValue(id);
    }

    private String getStatus() {
        IPersistentVolumeClaim pvc = (IPersistentVolumeClaim)this.getResource();
        String status = pvc.getStatus();
        if (StringUtils.isNotBlank((String)pvc.getVolumeName())) {
            return String.join((CharSequence)" ", status, "to volume", pvc.getVolumeName());
        }
        return status;
    }

    public static enum StorageIds {
        Modes,
        Requested,
        Status;

    }
}

