/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property.tabbed;

import com.openshift.restclient.model.IResource;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.OpenShiftAPIAnnotations;
import org.jboss.tools.openshift.internal.common.ui.utils.DateTimeUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.comparators.CreationTimestampComparator;
import org.jboss.tools.openshift.internal.ui.models.IResourceContainer;
import org.jboss.tools.openshift.internal.ui.models.IResourceWrapper;
import org.jboss.tools.openshift.internal.ui.property.tabbed.ResourceContainerContentProvider;

public class OpenShiftResourcePropertySection
extends AbstractPropertySection
implements OpenShiftAPIAnnotations {
    protected TableViewer table;
    protected PropertySheetPage details;
    protected TabbedPropertySheetPage page;
    private ISelectionProvider selectionProvider;
    private String menuContributionId;
    private String resourceKind;

    public OpenShiftResourcePropertySection(String menuContributionId, String kind) {
        this.resourceKind = kind;
        this.menuContributionId = menuContributionId;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.createContents(parent, aTabbedPropertySheetPage);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.page != null) {
            this.page.getSite().setSelectionProvider(this.selectionProvider);
        }
    }

    protected void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.page = aTabbedPropertySheetPage;
        parent.setLayout((Layout)new GridLayout());
        SashForm container = new SashForm(parent, 512);
        GridData d = new GridData(1808);
        d.widthHint = 100;
        d.heightHint = 100;
        container.setLayoutData((Object)d);
        Composite tableContainer = new Composite((Composite)container, 0);
        tableContainer.setLayout((Layout)new FillLayout());
        this.table = this.createTable(tableContainer);
        this.details = new PropertySheetPage();
        this.details.createControl((Composite)container);
        this.selectionProvider = new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                OpenShiftResourcePropertySection.this.table.removeSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                return OpenShiftResourcePropertySection.this.table.getSelection();
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                OpenShiftResourcePropertySection.this.table.addSelectionChangedListener(listener);
            }
        };
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerBuilder tableViewerBuilder = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ResourceContainerContentProvider(this.resourceKind));
        this.setSorter(tableViewerBuilder);
        this.addColumns(tableViewerBuilder);
        TableViewer viewer = tableViewerBuilder.buildViewer();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OpenShiftResourcePropertySection.this.details.selectionChanged(null, event.getSelection());
            }
        });
        this.addContextMenu(viewer);
        return viewer;
    }

    protected void setSorter(TableViewerBuilder tableViewerBuilder) {
        tableViewerBuilder.sorter(this.createNameSorter());
    }

    protected void addColumns(TableViewerBuilder tableViewerBuilder) {
        this.addNameColumn(tableViewerBuilder);
        this.addCreatedColumn(tableViewerBuilder);
        this.addLabelsColumn(tableViewerBuilder);
    }

    protected IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IAdaptable) {
            return (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return null;
    }

    protected void addNameColumn(TableViewerBuilder tableViewerBuilder) {
        tableViewerBuilder.column(model -> this.getResource(model).getName()).name("Name").align(16384).weight(1).minWidth(15).buildColumn();
    }

    protected void addCreatedColumn(TableViewerBuilder tableViewerBuilder) {
        tableViewerBuilder.column(model -> DateTimeUtils.formatSince((String)this.getResource(model).getCreationTimeStamp())).name("Created").align(16384).weight(1).minWidth(5).buildColumn();
    }

    protected void addLabelsColumn(TableViewerBuilder tableViewerBuilder) {
        tableViewerBuilder.column(model -> StringUtils.serialize((Map)this.getResource(model).getLabels())).name("Labels").align(16384).weight(1).minWidth(25).buildColumn();
    }

    protected void addContextMenu(TableViewer viewer) {
        if (this.menuContributionId != null) {
            IMenuManager contextMenu = UIUtils.createContextMenu((Control)viewer.getTable());
            UIUtils.registerContributionManager((String)this.menuContributionId, (IContributionManager)contextMenu, (Control)viewer.getTable());
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        IResourceContainer model = (IResourceContainer)UIUtils.getFirstElement((ISelection)selection, IResourceContainer.class);
        if (model == null) {
            return;
        }
        ITabDescriptor tab = this.page.getSelectedTab();
        if (tab == null) {
            return;
        }
        this.table.setInput((Object)model);
    }

    public void dispose() {
        if (this.table != null && this.table.getTable() != null) {
            this.table.getTable().dispose();
        }
        if (this.details != null) {
            this.details.dispose();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
        if (!DisposeUtils.isDisposed((Viewer)this.table)) {
            this.table.refresh();
        }
        if (!DisposeUtils.isDisposed((Control)this.details.getControl())) {
            this.details.refresh();
        }
    }

    protected ViewerComparator createCreatedBySorter() {
        final CreationTimestampComparator comparator = new CreationTimestampComparator();
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return comparator.compare((IResourceWrapper)e1, (IResourceWrapper)e2);
            }
        };
    }

    protected ViewerComparator createNameSorter() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IResource r1 = (IResource)((IResourceWrapper)e1).getWrapped();
                IResource r2 = (IResource)((IResourceWrapper)e2).getWrapped();
                return r1.getName().compareTo(r2.getName());
            }
        };
    }

    protected ViewerComparator createCreationTimestampSorter(final boolean descending) {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IResource r1 = (IResource)((IResourceWrapper)e1).getWrapped();
                IResource r2 = (IResource)((IResourceWrapper)e2).getWrapped();
                try {
                    Date d1 = DateTimeUtils.parse((String)r1.getCreationTimeStamp());
                    Date d2 = DateTimeUtils.parse((String)r2.getCreationTimeStamp());
                    return descending ? d2.compareTo(d1) : d1.compareTo(d2);
                }
                catch (ParseException e) {
                    OpenShiftUIActivator.log(4, "Unable to parse dates in OpenShift Resource Property Tab Section", e);
                    return 0;
                }
            }
        };
    }
}

