/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property.tabbed;

import com.openshift.restclient.model.volume.IPersistentVolumeClaim;
import org.apache.commons.lang.StringUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.ui.property.tabbed.OpenShiftResourcePropertySection;

public class StoragePropertySection
extends OpenShiftResourcePropertySection {
    public StoragePropertySection() {
        super("popup:org.jboss.tools.openshift.ui.properties.tab.StorageTab", "PersistentVolumeClaim");
    }

    @Override
    protected void addColumns(TableViewerBuilder tableViewerBuilder) {
        this.addNameColumn(tableViewerBuilder);
        tableViewerBuilder.column(model -> this.getStatus(model)).name("Status").align(16384).weight(1).minWidth(25).buildColumn();
        this.addCreatedColumn(tableViewerBuilder);
    }

    private String getStatus(Object model) {
        IPersistentVolumeClaim pvc = (IPersistentVolumeClaim)this.getResource(model);
        String status = pvc.getStatus();
        if (StringUtils.isNotBlank((String)pvc.getVolumeName())) {
            return String.join((CharSequence)" ", status, "to volume", pvc.getVolumeName());
        }
        return status;
    }
}

