/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.OpenShiftException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.IOpenShiftConnection;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizard;
import org.jboss.tools.openshift.internal.core.preferences.OCBinary;

public class ChooseOpenshiftConnectionComposite
extends Composite {
    private IConnectionChangedListener connectionChangeListener;
    private Combo connectionCombo;
    private Label serverValueLbl;
    private Label protocolValLbl;
    private Label usernameValLbl;
    private Label imageRegistryValLbl;
    private Label clusterNamespaceValLbl;
    private Label ocLocationValLbl;
    private Label userLbl;
    private List<IConnection> connections;
    private IConnection selectedConnection;
    private ControlDecoration ocLocationDecorator;

    public ChooseOpenshiftConnectionComposite(Composite parent) {
        super(parent, 0);
        this.createComposite(this);
    }

    public Composite createComposite(Composite main) {
        int selIndex;
        main.setLayout((Layout)new GridLayout(5, true));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        main.setLayoutData((Object)gd);
        Label connLabel = new Label(main, 0);
        connLabel.setText("Connection: ");
        this.connectionCombo = new Combo(main, 8);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.connectionCombo);
        Composite btnWrapper = new Composite(main, 0);
        btnWrapper.setLayout((Layout)new FillLayout());
        final Button editConBtn = new Button(btnWrapper, 8);
        editConBtn.setText("Edit...");
        final Button addConBtn = new Button(btnWrapper, 8);
        addConBtn.setText("New...");
        GridDataFactory.fillDefaults().applyTo((Control)btnWrapper);
        addConBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionWizard connectionWizard = new ConnectionWizard(null);
                int ret = WizardUtils.openWizardDialog((IWizard)connectionWizard, (Shell)addConBtn.getShell());
                if (ret == 0) {
                    ChooseOpenshiftConnectionComposite.this.refreshConnections();
                    IConnection c = connectionWizard.getConnection();
                    int ind = ChooseOpenshiftConnectionComposite.this.connections.indexOf(c);
                    if (ind != -1) {
                        ChooseOpenshiftConnectionComposite.this.connectionCombo.select(ind);
                    }
                }
            }
        });
        editConBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionWizard connectionWizard = new ConnectionWizard(ChooseOpenshiftConnectionComposite.this.selectedConnection, "Edit OpenShift Connection");
                WizardUtils.openWizardDialog((IWizard)connectionWizard, (Shell)editConBtn.getShell());
                ChooseOpenshiftConnectionComposite.this.refreshConnections();
                IConnection c = connectionWizard.getConnection();
                int ind = ChooseOpenshiftConnectionComposite.this.connections.indexOf(c);
                if (ind != -1) {
                    ChooseOpenshiftConnectionComposite.this.connectionCombo.select(ind);
                    ChooseOpenshiftConnectionComposite.this.setSelectedConnection(c);
                }
            }
        });
        Label serverLbl = new Label(main, 0);
        serverLbl.setText("Server: ");
        this.serverValueLbl = new Label(main, 0);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)this.serverValueLbl);
        Group authGroup = new Group(main, 0);
        authGroup.setText("Authentication");
        GridDataFactory.fillDefaults().span(5, 1).indent(0, 5).applyTo((Control)authGroup);
        authGroup.setLayout((Layout)new GridLayout(6, true));
        Label protocolLbl = new Label((Composite)authGroup, 0);
        protocolLbl.setText("Protocol: ");
        this.protocolValLbl = new Label((Composite)authGroup, 0);
        GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)this.protocolValLbl);
        this.userLbl = new Label((Composite)authGroup, 0);
        this.userLbl.setText("Username: ");
        this.usernameValLbl = new Label((Composite)authGroup, 0);
        GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)this.usernameValLbl);
        Group advancedGroup = new Group(main, 0);
        advancedGroup.setText("Advanced");
        GridDataFactory.fillDefaults().span(5, 1).indent(0, 5).applyTo((Control)advancedGroup);
        advancedGroup.setLayout((Layout)new GridLayout(6, true));
        Label imageRegistryLbl = new Label((Composite)advancedGroup, 0);
        imageRegistryLbl.setText("Image Registry URL: ");
        this.imageRegistryValLbl = new Label((Composite)advancedGroup, 0);
        GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)this.imageRegistryValLbl);
        Label clusterNamespaceLbl = new Label((Composite)advancedGroup, 0);
        clusterNamespaceLbl.setText("Cluster namespace: ");
        this.clusterNamespaceValLbl = new Label((Composite)advancedGroup, 0);
        GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)this.clusterNamespaceValLbl);
        Label ocLocationLbl = new Label((Composite)advancedGroup, 0);
        ocLocationLbl.setText("OC Binary Location: ");
        this.ocLocationValLbl = new Label((Composite)advancedGroup, 0);
        this.ocLocationDecorator = new ControlDecoration((Control)this.ocLocationValLbl, 16512);
        GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)this.ocLocationValLbl);
        this.refreshConnections();
        this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = ChooseOpenshiftConnectionComposite.this.connectionCombo.getSelectionIndex();
                if (selIndex != -1 && selIndex < ChooseOpenshiftConnectionComposite.this.connections.size()) {
                    ChooseOpenshiftConnectionComposite.this.setSelectedConnection((IConnection)ChooseOpenshiftConnectionComposite.this.connections.get(selIndex));
                }
                editConBtn.setEnabled(selIndex != -1);
            }
        });
        if (this.connectionCombo.getItemCount() > 0) {
            this.connectionCombo.select(0);
            this.setSelectedConnection(this.connections.get(0));
        }
        editConBtn.setEnabled((selIndex = this.connectionCombo.getSelectionIndex()) != -1);
        return main;
    }

    private void validateOCLocation() {
        if (this.selectedConnection != null) {
            String ocValString = OCBinary.getInstance().getLocation(this.selectedConnection);
            if (StringUtils.isEmpty((String)ocValString)) {
                this.ocLocationDecorator.show();
                this.ocLocationDecorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
                this.ocLocationDecorator.setDescriptionText("The selected connection does not have an 'oc' command associated with it. Please edit the connection or modify your workspace settings to add one.");
            } else {
                this.ocLocationDecorator.hide();
            }
        }
    }

    private void refreshConnections() {
        int ind;
        String selectedName = this.selectedConnection == null ? null : this.createLabel(this.selectedConnection);
        Collection allCons = ConnectionsRegistrySingleton.getInstance().getAll();
        this.connections = allCons.stream().filter(connection -> connection instanceof IOpenShiftConnection).collect(Collectors.toList());
        ArrayList connectionNames = new ArrayList();
        allCons.forEach(con -> {
            boolean bl = connectionNames.add(this.createLabel((IConnection)con));
        });
        this.connectionCombo.setItems(connectionNames.toArray(new String[connectionNames.size()]));
        if (selectedName != null && connectionNames.contains(selectedName) && (ind = connectionNames.indexOf(selectedName)) != -1) {
            this.connectionCombo.select(ind);
        }
    }

    private void setSelectedConnection(IConnection con) {
        this.selectedConnection = con;
        if (this.selectedConnection != null) {
            this.serverValueLbl.setText(con.getHost());
            if (con instanceof IOpenShiftConnection) {
                String authScheme = ((Connection)con).getAuthScheme();
                this.protocolValLbl.setText(authScheme);
                if ("Basic".equals(authScheme)) {
                    this.usernameValLbl.setText(con.getUsername());
                } else {
                    this.usernameValLbl.setText("Not applicable");
                }
                Map eProps = ((IOpenShiftConnection)con).getExtendedProperties();
                Object imgReg = eProps.get("org.jbosstools.openshift.core.connection.ext.registry.url");
                String imgRegVal = imgReg == null ? "" : imgReg.toString();
                this.imageRegistryValLbl.setText(imgRegVal);
                this.clusterNamespaceValLbl.setText(((Connection)con).getClusterNamespace());
            } else {
                this.protocolValLbl.setText("");
                this.imageRegistryValLbl.setText("");
                this.clusterNamespaceValLbl.setText("");
            }
            String ocValString = OCBinary.getInstance().getLocation(con);
            if (ocValString == null) {
                ocValString = "";
            }
            this.ocLocationValLbl.setText(ocValString);
            this.validateOCLocation();
        } else {
            this.serverValueLbl.setText("");
            this.protocolValLbl.setText("");
            this.usernameValLbl.setText("");
            this.imageRegistryValLbl.setText("");
            this.clusterNamespaceValLbl.setText("");
            this.ocLocationValLbl.setText("");
        }
        if (this.connectionChangeListener != null) {
            this.connectionChangeListener.connectionChanged(this.selectedConnection);
        }
    }

    private String createLabel(IConnection connection) {
        StringBuilder builder = new StringBuilder();
        String username = connection.getUsername();
        if (!StringUtils.isEmpty((String)username)) {
            builder.append(connection.getUsername()).append(" - ");
        }
        builder.append(connection.getHost());
        return builder.toString();
    }

    public Job getConnectJob() {
        return new Job("Connecting to OpenShift"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String blockedMsg = this.runConnectionOrError();
                    if (blockedMsg == null) {
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "org.jboss.tools.openshift.ui", blockedMsg);
                }
                catch (OpenShiftException | IOException ioe) {
                    return new Status(4, "org.jboss.tools.openshift.ui", "Error while connecting to OpenShift: " + ioe.getMessage(), ioe);
                }
            }

            private String runConnectionOrError() throws IOException, OpenShiftException {
                String blockedMsg = null;
                if (ChooseOpenshiftConnectionComposite.this.selectedConnection != null && ChooseOpenshiftConnectionComposite.this.selectedConnection.canConnect()) {
                    boolean connected = ChooseOpenshiftConnectionComposite.this.selectedConnection.connect();
                    if (!connected) {
                        blockedMsg = "Unable to connect to OpenShift connection";
                    }
                } else {
                    blockedMsg = ChooseOpenshiftConnectionComposite.this.selectedConnection == null ? "Please select an OpenShift connection." : "Unable to connect to selected OpenShift Connection";
                }
                return blockedMsg;
            }
        };
    }

    public void setConnectionChangeListener(IConnectionChangedListener connectionChangeListener) {
        this.connectionChangeListener = connectionChangeListener;
    }

    public IConnection getConnection() {
        return this.selectedConnection;
    }

    public static interface IConnectionChangedListener {
        public void connectionChanged(IConnection var1);
    }
}

