/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.route.IRoute;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyCommand;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.util.OpenShiftResourceUniqueId;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.ui.server.ServerSettingsWizardPageModel;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class OpenShiftServerEditorModel
extends ServerSettingsWizardPageModel {
    public static final String PROPERTY_OVERRIDE_PROJECT = "overrideProject";
    private ServerEditorSection section;
    private boolean initializing = true;
    private boolean overrideProject = false;
    private IObservableValue<String> devmodeKeyObservable;
    private IObservableValue<String> debugPortKeyObservable;
    private IObservableValue<String> debugPortValueObservable;

    public OpenShiftServerEditorModel(IServerWorkingCopy server, ServerEditorSection section, Connection connection) {
        super(null, null, null, connection, server, Status.OK_STATUS);
        this.section = section;
        this.initChangelisteners(server, section);
    }

    private void initChangelisteners(IServerWorkingCopy server, ServerEditorSection section) {
        this.devmodeKeyObservable = BeanProperties.value((String)"devmodeKey").observe((Object)this);
        this.devmodeKeyObservable.addValueChangeListener(event -> {
            if (this.initializing) {
                return;
            }
            section.execute((IUndoableOperation)new SetStringCommand(server, "SetDevmodeKey", "org.jboss.tools.openshift.DevmodeKey", (String)event.diff.getOldValue(), (String)event.diff.getNewValue()));
        });
        this.debugPortKeyObservable = BeanProperties.value((String)"debugPortKey").observe((Object)this);
        this.debugPortKeyObservable.addValueChangeListener(event -> {
            if (this.initializing) {
                return;
            }
            section.execute((IUndoableOperation)new SetStringCommand(server, "SetDebugPortKey", "org.jboss.tools.openshift.DebugPortKey", (String)event.diff.getOldValue(), (String)event.diff.getNewValue()));
        });
        this.debugPortValueObservable = BeanProperties.value((String)"debugPortValue").observe((Object)this);
        this.debugPortValueObservable.addValueChangeListener(event -> {
            if (this.initializing) {
                return;
            }
            section.execute((IUndoableOperation)new SetStringCommand(server, "SetDebugPortValue", "org.jboss.tools.openshift.DebugPortValue", (String)event.diff.getOldValue(), (String)event.diff.getNewValue()));
        });
    }

    private void update(boolean overrideProject, Connection connection, List<Connection> connections, org.eclipse.core.resources.IProject deployProject, List<org.eclipse.core.resources.IProject> projects, String sourcePath, String podPath, boolean isUseInferredPodPath, IResource resource, List<ObservableTreeItem> resourceItems, IRoute route, boolean isSelectDefaultRoute, Map<IProject, List<IRoute>> routesByProject, boolean useImageDevmodeKey, String devmodeKey, boolean useImageDebugPortKey, String debugPortKey, boolean useImageDebugPortValue, String debugPortValue) {
        this.update(connection, connections, deployProject, projects, sourcePath, podPath, isUseInferredPodPath, resource, resourceItems, route, isSelectDefaultRoute, routesByProject, this.getOCBinaryStatus(), useImageDevmodeKey, devmodeKey, useImageDebugPortKey, debugPortKey, useImageDebugPortValue, debugPortValue);
        this.overrideProject = overrideProject;
        this.firePropertyChange(PROPERTY_OVERRIDE_PROJECT, this.overrideProject, this.overrideProject);
    }

    public boolean isOverrideProject() {
        return this.overrideProject;
    }

    public void setOverrideProject(boolean overrideProject) {
        this.update(overrideProject, this.getConnection(), this.getConnections(), this.getDeployProject(), this.getProjects(), this.getSourcePath(), this.getPodPath(), this.isUseInferredPodPath(), this.getResource(), this.getResourceItems(), this.getRoute(), this.isSelectDefaultRoute(), this.getAllRoutes(), this.isUseImageDevmodeKey(), this.getDevmodeKey(), this.isUseImageDebugPortKey(), this.getDebugPortKey(), this.isUseImageDebugPortValue(), this.getDebugPortValue());
    }

    @Override
    protected org.eclipse.core.resources.IProject getProjectOrDefault(org.eclipse.core.resources.IProject project, List<org.eclipse.core.resources.IProject> projects) {
        return project;
    }

    @Override
    protected IResource getResourceOrDefault(IResource resource, List<ObservableTreeItem> services) {
        return resource;
    }

    @Override
    public void setRoute(IRoute newRoute) {
        this.setRoute(newRoute, !this.initializing);
    }

    public void setRoute(IRoute newRoute, boolean executeCommand) {
        String prevHost = this.getHost(this.getRoute());
        super.setRoute(newRoute);
        String newHost = this.getHost(newRoute);
        String newRouteURL = this.getRouteURL(this.isSelectDefaultRoute(), newRoute);
        if (executeCommand) {
            this.section.execute((IUndoableOperation)new SetRouteCommand(this.getServer(), this.getRoute(), newRoute, newRouteURL, prevHost, newHost));
        }
    }

    @Override
    public void setConnection(Connection connection) {
        this.setConnection(connection, !this.initializing);
    }

    public void setConnection(Connection connection, boolean executeCommand) {
        Connection previous = this.getConnection();
        String newUrl = connection == null ? null : this.getConnectionUrl((IConnection)connection);
        super.setConnection(connection);
        if (executeCommand) {
            this.section.execute((IUndoableOperation)new SetConnectionCommand(this.getServer(), previous, connection, newUrl));
        }
    }

    @Override
    public void setResource(IResource resource) {
        this.setResource(resource, !this.initializing);
    }

    public void setResource(IResource resource, boolean executeCommand) {
        IResource previous = this.getResource();
        super.setResource(resource);
        if (executeCommand) {
            this.section.execute((IUndoableOperation)new SetResourceCommand(this.getServer(), previous, resource));
        }
    }

    @Override
    public void setDeployProject(org.eclipse.core.resources.IProject project) {
        this.setDeployProject(project, !this.initializing);
    }

    public void setDeployProject(org.eclipse.core.resources.IProject project, boolean executeCommand) {
        org.eclipse.core.resources.IProject previous = super.getDeployProject();
        super.setDeployProject(project);
        if (executeCommand) {
            this.section.execute((IUndoableOperation)new SetDeployProjectCommand(this.getServer(), previous, project));
        }
    }

    @Override
    public void setSourcePath(String sourcePath) {
        this.setSourcePath(sourcePath, !this.initializing);
    }

    public void setSourcePath(String sourcePath, boolean executeCommand) {
        String previous = this.getSourcePath();
        super.setSourcePath(sourcePath);
        if (executeCommand) {
            this.section.execute((IUndoableOperation)new SetSourcePathCommand(this.getServer(), previous, sourcePath));
        }
    }

    @Override
    public void setPodPath(String podPath) {
        this.setPodPath(podPath, !this.initializing);
    }

    public void setPodPath(String podPath, boolean executeCommand) {
        String previous = this.getPodPath();
        super.setPodPath(podPath);
        if (executeCommand) {
            this.section.execute((IUndoableOperation)new SetPodPathCommand(this.getServer(), previous, podPath));
        }
    }

    public void setInitializing(boolean initializing) {
        this.initializing = initializing;
    }

    @Override
    public void dispose() {
        DataBindingUtils.dispose(this.devmodeKeyObservable);
        DataBindingUtils.dispose(this.debugPortKeyObservable);
        DataBindingUtils.dispose(this.debugPortValueObservable);
    }

    public class SetConnectionCommand
    extends ServerWorkingCopyPropertyCommand {
        private Connection oldConnection;
        private Connection newConnection;

        public SetConnectionCommand(IServerWorkingCopy server, Connection oldConnection, Connection newConnection, String conUrl) {
            super(server, "Set Connection...", null, conUrl, "org.jboss.tools.openshift.Connection", null);
            this.oldConnection = oldConnection;
            this.newConnection = newConnection;
        }

        public void undo() {
            super.undo();
            OpenShiftServerEditorModel.this.setConnection(this.oldConnection, false);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
            OpenShiftServerEditorModel.this.setConnection(this.newConnection, false);
            return super.redo(monitor, adapt);
        }
    }

    public class SetDeployProjectCommand
    extends ServerWorkingCopyPropertyCommand {
        private org.eclipse.core.resources.IProject oldProj;
        private org.eclipse.core.resources.IProject newProj;

        public SetDeployProjectCommand(IServerWorkingCopy server, org.eclipse.core.resources.IProject oldProj, org.eclipse.core.resources.IProject newProj) {
            super(server, "Set Project...", null, ProjectUtils.getName((org.eclipse.core.resources.IProject)OpenShiftServerEditorModel.this.deployProject), "org.jboss.tools.openshift.DeployProject", null);
            this.oldProj = oldProj;
            this.newProj = newProj;
        }

        public void undo() {
            super.undo();
            OpenShiftServerEditorModel.this.setDeployProject(this.oldProj, false);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
            OpenShiftServerEditorModel.this.setDeployProject(this.newProj, false);
            return super.redo(monitor, adapt);
        }
    }

    public class SetPodPathCommand
    extends ServerWorkingCopyPropertyCommand {
        private String oldPath;
        private String newPath;

        public SetPodPathCommand(IServerWorkingCopy server, String oldPath, String newPath) {
            super(server, "Set Pod Path...", null, newPath, "org.jboss.tools.openshift.PodPath", null);
            this.oldPath = oldPath;
            this.newPath = newPath;
        }

        public void undo() {
            super.undo();
            OpenShiftServerEditorModel.this.setPodPath(this.oldPath, false);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
            OpenShiftServerEditorModel.this.setPodPath(this.newPath, false);
            return super.redo(monitor, adapt);
        }
    }

    private class SetResourceCommand
    extends ServerWorkingCopyPropertyCommand {
        private IResource oldResource;
        private IResource newResource;

        public SetResourceCommand(IServerWorkingCopy server, IResource oldResource, IResource newResource) {
            super(server, "Set Resource...", null, OpenShiftResourceUniqueId.get((IResource)newResource), "org.jboss.tools.openshift.Service", null);
            this.oldResource = oldResource;
            this.newResource = newResource;
        }

        public void undo() {
            super.undo();
            OpenShiftServerEditorModel.this.setResource(this.oldResource, false);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
            OpenShiftServerEditorModel.this.setResource(this.newResource, false);
            return super.redo(monitor, adapt);
        }
    }

    public class SetRouteCommand
    extends ServerWorkingCopyPropertyCommand {
        private IRoute oldRoute;
        private IRoute newRoute;
        private String oldHost;
        private String newHost;

        public SetRouteCommand(IServerWorkingCopy server, IRoute oldRoute, IRoute newRoute, String newRouteURL, String oldHost, String newHost) {
            super(server, "Set Route...", null, newRouteURL, "org.jboss.tools.openshift.Route", null);
            this.oldRoute = oldRoute;
            this.newRoute = newRoute;
        }

        public void undo() {
            super.undo();
            OpenShiftServerEditorModel.this.setRoute(this.oldRoute, false);
            OpenShiftServerEditorModel.this.getServer().setHost(this.oldHost);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
            OpenShiftServerEditorModel.this.setRoute(this.newRoute, false);
            IStatus s = super.redo(monitor, adapt);
            OpenShiftServerEditorModel.this.getServer().setHost(this.newHost);
            return s;
        }
    }

    public class SetSourcePathCommand
    extends ServerWorkingCopyPropertyCommand {
        private String oldPath;
        private String newPath;

        public SetSourcePathCommand(IServerWorkingCopy server, String oldPath, String newPath) {
            super(server, "Set Source Path...", null, newPath, "org.jboss.tools.openshift.SourcePath", null);
            this.oldPath = oldPath;
            this.newPath = newPath;
        }

        public void undo() {
            super.undo();
            OpenShiftServerEditorModel.this.setSourcePath(this.oldPath, false);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
            OpenShiftServerEditorModel.this.setSourcePath(this.newPath, false);
            return super.redo(monitor, adapt);
        }
    }

    public class SetStringCommand
    extends SetValueCommand<String> {
        public SetStringCommand(IServerWorkingCopy server, String name, String attributeKey, String oldValue, String newValue) {
            super(server, name, attributeKey, oldValue, newValue);
        }

        @Override
        protected String valueToString(String value) {
            return value;
        }
    }

    public abstract class SetValueCommand<T>
    extends ServerCommand {
        private T oldValue;
        private T newValue;
        private String attributeKey;

        public SetValueCommand(IServerWorkingCopy server, String name, String attributeKey, T oldValue, T newValue) {
            super(server, name);
            this.attributeKey = attributeKey;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        protected void updateModel(T value) {
        }

        protected abstract String valueToString(T var1);

        public void execute() {
            OpenShiftServerEditorModel.this.getServer().setAttribute(this.attributeKey, this.valueToString(this.newValue));
            this.updateModel(this.newValue);
        }

        public void undo() {
            this.updateModel(this.oldValue);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
            this.updateModel(this.newValue);
            return super.redo(monitor, adapt);
        }
    }
}

