/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IResource;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.comparators.ProjectViewerComparator;
import org.jboss.tools.openshift.internal.ui.server.ResourceDetailViews;
import org.jboss.tools.openshift.internal.ui.server.ResourcesViewLabelProvider;
import org.jboss.tools.openshift.internal.ui.server.ServerResourceViewModel;
import org.jboss.tools.openshift.internal.ui.server.ServiceViewerFilter;
import org.jboss.tools.openshift.internal.ui.treeitem.Model2ObservableTreeItemConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;

public class SelectResourceWizard
extends AbstractOpenShiftWizard<ServerResourceViewModel> {
    private String description;

    public SelectResourceWizard(String description, IResource resource, Connection connection) {
        super("Select Resource", (Object)new ServerResourceViewModel(resource, connection));
        this.description = description;
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new SelectResourceWizardPage());
    }

    public IResource getResource() {
        return ((ServerResourceViewModel)((Object)this.getModel())).getResource();
    }

    public class SelectResourceWizardPage
    extends AbstractOpenShiftWizardPage {
        public SelectResourceWizardPage() {
            super(SelectResourceWizard.this.getWindowTitle(), SelectResourceWizard.this.description, "", (IWizard)SelectResourceWizard.this);
        }

        protected void doCreateControls(Composite parent, DataBindingContext dbc) {
            GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
            Composite container = new Composite(parent, 0);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
            GridLayoutFactory.fillDefaults().applyTo(container);
            Composite serviceComposite = this.createServiceControls(container, dbc);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)serviceComposite);
            this.loadResources();
        }

        private Composite createServiceControls(Composite container, DataBindingContext dbc) {
            Group servicesGroup = new Group(container, 0);
            servicesGroup.setText("Services");
            GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)servicesGroup);
            Label selectorLabel = new Label((Composite)servicesGroup, 0);
            selectorLabel.setText("Selector:");
            Text selectorText = UIUtils.createSearchText((Composite)servicesGroup);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)selectorText);
            TreeViewer resourcesViewer = this.createServicesTreeViewer((Composite)servicesGroup, selectorText);
            resourcesViewer.addDoubleClickListener(this.onDoubleClickService());
            IObservableList resourceItemsObservable = BeanProperties.list((String)"resourceItems").observe(SelectResourceWizard.this.getModel());
            DataBindingUtils.addDisposableListChangeListener(this.onServiceItemsChanged(resourcesViewer), (IObservableList)resourceItemsObservable, (Control)resourcesViewer.getTree());
            GridDataFactory.fillDefaults().span(2, 1).align(4, 4).hint(-1, 160).grab(true, true).applyTo(resourcesViewer.getControl());
            selectorText.addModifyListener(this.onFilterTextModified(resourcesViewer));
            IViewerObservableValue selectedResourceTreeItem = ViewerProperties.singleSelection().observe((Viewer)resourcesViewer);
            ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedResourceTreeItem).converting((IConverter)new ObservableTreeItem2ModelConverter(IResource.class))).validatingAfterConvert(new IValidator(){

                public IStatus validate(Object value) {
                    if (value instanceof IResource && OpenShiftServerUtils.isAllowedForServerAdapter((IResource)((IResource)value))) {
                        return ValidationStatus.ok();
                    }
                    return ValidationStatus.cancel((String)"Please select a resource that your adapter will publish to.");
                }
            })).to(BeanProperties.value((String)"resource").observe(SelectResourceWizard.this.getModel())).converting((IConverter)new Model2ObservableTreeItemConverter(new ServerResourceViewModel.ResourceTreeItemsFactory()))).in(dbc);
            Label detailsLabel = new Label((Composite)servicesGroup, 0);
            detailsLabel.setText("Resource Details:");
            GridDataFactory.fillDefaults().span(2, 1).align(4, 4).applyTo((Control)detailsLabel);
            Composite detailsContainer = new Composite((Composite)servicesGroup, 0);
            GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, false).hint(-1, 150).applyTo((Control)detailsContainer);
            WritableValue selectedResource = new WritableValue();
            ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedResourceTreeItem).converting((IConverter)new ObservableTreeItem2ModelConverter())).to((IObservableValue)selectedResource).notUpdatingParticipant()).in(dbc);
            new ResourceDetailViews((IObservableValue)selectedResource, detailsContainer, dbc).createControls();
            return servicesGroup;
        }

        private IDoubleClickListener onDoubleClickService() {
            return new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (SelectResourceWizard.this.canFinish()) {
                        Button finishButton = SelectResourceWizardPage.this.getShell().getDefaultButton();
                        UIUtils.clickButton((Button)finishButton);
                    }
                }
            };
        }

        private IListChangeListener<Object> onServiceItemsChanged(final TreeViewer servicesViewer) {
            return new IListChangeListener<Object>(){

                public void handleListChange(ListChangeEvent<? extends Object> event) {
                    servicesViewer.expandAll();
                }
            };
        }

        private TreeViewer createServicesTreeViewer(Composite parent, Text selectorText) {
            TreeViewer applicationTemplatesViewer = new TreeViewer(parent, 2820);
            MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"resourceItems"), BeanProperties.list((String)"children")});
            ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
            applicationTemplatesViewer.setContentProvider((IContentProvider)contentProvider);
            applicationTemplatesViewer.setLabelProvider((IBaseLabelProvider)new ResourcesViewLabelProvider());
            applicationTemplatesViewer.addFilter((ViewerFilter)new ServiceViewerFilter(selectorText));
            applicationTemplatesViewer.setComparator(ProjectViewerComparator.createProjectTreeSorter());
            applicationTemplatesViewer.setAutoExpandLevel(-1);
            applicationTemplatesViewer.setInput(SelectResourceWizard.this.getModel());
            return applicationTemplatesViewer;
        }

        protected ModifyListener onFilterTextModified(final TreeViewer applicationTemplatesViewer) {
            return new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    applicationTemplatesViewer.refresh();
                    applicationTemplatesViewer.expandAll();
                }
            };
        }

        private void loadResources() {
            final IStatus[] stats = new IStatus[1];
            try {
                WizardUtils.runInWizard((Job)new Job("Loading services..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ((ServerResourceViewModel)((Object)SelectResourceWizard.this.getModel())).loadResources();
                            stats[0] = Status.OK_STATUS;
                        }
                        catch (OpenShiftException ose) {
                            stats[0] = OpenShiftUIActivator.statusFactory().errorStatus("Unable to load services from the given connection", (Throwable)ose);
                        }
                        return Status.OK_STATUS;
                    }
                }, (IWizardContainer)this.getWizard().getContainer());
            }
            catch (InterruptedException | InvocationTargetException exception) {}
            if (!stats[0].isOK()) {
                this.setErrorMessage(stats[0].getMessage());
            }
        }
    }
}

