/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.ExtensionUtils;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.common.core.utils.VariablesHelper;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.core.server.adapter.IOpenshiftServerAdapterProfileDetector;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.server.ServerResourceViewModel;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.utils.ObservableTreeItemUtils;

public class ServerSettingsWizardPageModel
extends ServerResourceViewModel
implements IResourceChangeListener {
    public static final String PROPERTY_DEPLOYPROJECT = "deployProject";
    public static final String PROPERTY_PROJECTS = "projects";
    public static final String PROPERTY_SOURCE_PATH = "sourcePath";
    public static final String PROPERTY_POD_PATH = "podPath";
    public static final String PROPERTY_USE_INFERRED_POD_PATH = "useInferredPodPath";
    public static final String PROPERTY_SELECT_DEFAULT_ROUTE = "selectDefaultRoute";
    public static final String PROPERTY_ROUTE = "route";
    public static final String PROPERTY_ROUTES = "routes";
    public static final String PROPERTY_USE_IMAGE_DEVMODE_KEY = "useImageDevmodeKey";
    public static final String PROPERTY_DEVMODE_KEY = "devmodeKey";
    public static final String PROPERTY_USE_IMAGE_DEBUG_PORT_KEY = "useImageDebugPortKey";
    public static final String PROPERTY_DEBUG_PORT_KEY = "debugPortKey";
    public static final String PROPERTY_USE_IMAGE_DEBUG_PORT_VALUE = "useImageDebugPortValue";
    public static final String PROPERTY_DEBUG_PORT_VALUE = "debugPortValue";
    public static final String PROPERTY_OC_BINARY_STATUS = "OCBinaryStatus";
    private static final String PROFILE_DETECTOR_EP_ID = "org.jboss.tools.openshift.core.serverAdapterProfileDetector";
    protected IProject deployProject;
    protected List<IProject> projects = new ArrayList<IProject>();
    private String sourcePath;
    protected String podPath;
    protected String inferredPodPath = null;
    private IServerWorkingCopy server;
    private boolean selectDefaultRoute = false;
    private IRoute route;
    private Map<com.openshift.restclient.model.IProject, List<IRoute>> routesByProject = new HashMap<com.openshift.restclient.model.IProject, List<IRoute>>();
    private List<IRoute> serviceRoutes = new ArrayList<IRoute>();
    private boolean isLoaded = false;
    private Map<com.openshift.restclient.model.IProject, List<IBuildConfig>> buildConfigsByProject;
    private boolean useInferredPodPath = true;
    private IStatus ocBinaryStatus = Status.OK_STATUS;
    protected boolean useImageDevmodeKey = true;
    protected String devmodeKey;
    protected boolean useImageDebugPortKey = true;
    protected String debugPortKey;
    protected boolean useImageDebugPortValue = true;
    protected String debugPortValue;

    protected ServerSettingsWizardPageModel(IResource resource, IRoute route, IProject deployProject, Connection connection, IServerWorkingCopy server) {
        this(resource, route, deployProject, connection, server, Status.OK_STATUS);
    }

    public ServerSettingsWizardPageModel(IResource resource, IRoute route, IProject deployProject, Connection connection, IServerWorkingCopy server, IStatus ocBinaryStatus) {
        super(resource, connection);
        this.route = route;
        this.deployProject = deployProject;
        this.server = server;
        this.init(server);
        this.ocBinaryStatus = ocBinaryStatus;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    private void init(IServerWorkingCopy server) {
        this.devmodeKey = OpenShiftServerUtils.getDevmodeKey((IServerAttributes)server);
        this.useImageDevmodeKey = this.isUseImageDevmodeKey(this.devmodeKey);
        this.debugPortKey = OpenShiftServerUtils.getDebugPortKey((IServerAttributes)server);
        this.useImageDebugPortKey = this.isUseImageDebugPortKey(this.debugPortKey);
        this.debugPortValue = OpenShiftServerUtils.getDebugPort((IServerAttributes)server);
        this.useImageDebugPortValue = this.isUseImageDebugPortValue(this.debugPortValue);
    }

    protected void update(Connection connection, List<Connection> connections, IProject deployProject, List<IProject> projects, String sourcePath, String podPath, boolean useInferredPodPath, IResource resource, List<ObservableTreeItem> resourceItems, IRoute route, boolean isSelectDefaultRoute, Map<com.openshift.restclient.model.IProject, List<IRoute>> routesByProject, IStatus ocBinaryStatus, boolean useImageDevmodeKey, String devmodeKey, boolean useImageDebugPortKey, String debugPortKey, boolean useImageDebugPortValue, String debugPortValue) {
        this.update(connection, connections, resource, resourceItems);
        this.updateProjects(projects);
        IProject oldDeployProject = this.deployProject;
        IProject newDeployProject = this.updateDeployProject(deployProject, projects, resource);
        sourcePath = this.updateSourcePath(sourcePath, newDeployProject, oldDeployProject);
        List<IRoute> newRoutes = this.updateRoutes(resource, routesByProject);
        this.updateRoute(route, newRoutes, resource);
        this.updateSelectDefaultRoute(isSelectDefaultRoute);
        this.updateOCBinaryStatus(ocBinaryStatus);
        this.useInferredPodPath = useInferredPodPath;
        this.firePropertyChange(PROPERTY_USE_INFERRED_POD_PATH, this.useInferredPodPath, this.useInferredPodPath);
        this.podPath = podPath;
        this.firePropertyChange(PROPERTY_POD_PATH, this.podPath, this.podPath);
        this.updateDevmode(useImageDevmodeKey, devmodeKey);
        this.updateDebugPort(useImageDebugPortKey, debugPortKey, useImageDebugPortValue, debugPortValue);
    }

    private void updateProjects(List<IProject> projects) {
        if (projects == this.projects) {
            return;
        }
        ArrayList<IProject> oldProjects = new ArrayList<IProject>(this.projects);
        ArrayList<IProject> newProjects = new ArrayList<IProject>();
        if (projects != null) {
            newProjects.addAll(projects);
        }
        this.projects.clear();
        this.projects.addAll(newProjects);
        this.firePropertyChange(PROPERTY_PROJECTS, oldProjects, this.projects);
    }

    protected IProject updateDeployProject(IProject newDeployProject, List<IProject> projects, IResource resource) {
        if (!(newDeployProject != null && projects.contains(newDeployProject) || (newDeployProject = this.getDeployProject(resource)) != null)) {
            newDeployProject = this.getProjectOrDefault(newDeployProject, projects);
        }
        this.deployProject = newDeployProject;
        this.firePropertyChange(PROPERTY_DEPLOYPROJECT, this.deployProject, this.deployProject);
        return this.deployProject;
    }

    protected String updateSourcePath(String sourcePath, IProject newDeployProject, IProject oldDeployProject) {
        if ((StringUtils.isEmpty((String)sourcePath) || newDeployProject != oldDeployProject) && ProjectUtils.isAccessible((IProject)newDeployProject)) {
            sourcePath = VariablesHelper.addWorkspacePrefix((String)newDeployProject.getFullPath().toString());
        }
        this.sourcePath = sourcePath;
        this.firePropertyChange(PROPERTY_SOURCE_PATH, this.sourcePath, this.sourcePath);
        return sourcePath;
    }

    protected List<IRoute> updateRoutes(IResource resource, Map<com.openshift.restclient.model.IProject, List<IRoute>> routesByProject) {
        this.routesByProject = routesByProject;
        ArrayList<IRoute> oldRoutes = new ArrayList<IRoute>(this.serviceRoutes);
        List<IRoute> routes = this.getRoutes(resource);
        this.serviceRoutes.clear();
        this.serviceRoutes.addAll(routes);
        this.resetSelectedRoute();
        this.firePropertyChange(PROPERTY_ROUTES, oldRoutes, this.serviceRoutes);
        return routes;
    }

    private void resetSelectedRoute() {
        if (this.route != null) {
            this.route = null;
            this.firePropertyChange(PROPERTY_ROUTE, this.route, null);
        }
    }

    protected IRoute updateRoute(IRoute route, List<IRoute> routes, IResource resource) {
        if (!this.isLoaded) {
            return null;
        }
        if (routes == null || routes.isEmpty()) {
            route = null;
        } else if (route == null || !routes.contains(route)) {
            if (resource instanceof IService) {
                route = ResourceUtils.getRouteFor((IService)((IService)resource), routes);
            }
            if (route == null || !routes.contains(route)) {
                route = routes.get(0);
            }
        }
        this.route = route;
        this.firePropertyChange(PROPERTY_ROUTE, this.route, this.route);
        return this.route;
    }

    private void updateSelectDefaultRoute(boolean selectDefaultRoute) {
        this.selectDefaultRoute = selectDefaultRoute;
        this.firePropertyChange(PROPERTY_SELECT_DEFAULT_ROUTE, this.selectDefaultRoute, this.selectDefaultRoute);
    }

    protected IProject getDeployProject(IResource resource) {
        if (resource == null) {
            return null;
        }
        com.openshift.restclient.model.IProject openShiftProject = this.getOpenShiftProject(resource);
        List<IBuildConfig> buildConfigs = this.getBuildConfigs(openShiftProject);
        IBuildConfig buildConfig = ResourceUtils.getBuildConfigFor((IResource)resource, buildConfigs);
        return ResourceUtils.getWorkspaceProjectFor((IBuildConfig)buildConfig, this.getProjects());
    }

    public void setDeployProject(IProject project) {
        this.update(this.getConnection(), this.getConnections(), project, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    public IProject getDeployProject() {
        return this.deployProject;
    }

    protected void setProjects(List<IProject> projects) {
        this.updateProjects(projects);
    }

    public List<IProject> getProjects() {
        return this.projects;
    }

    public void setSourcePath(String sourcePath) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setPodPath(String podPath) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    public String getPodPath() {
        return this.podPath;
    }

    public boolean isUseInferredPodPath() {
        return this.useInferredPodPath;
    }

    public void setUseInferredPodPath(boolean useInferredPodPath) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    @Override
    public void setResource(IResource resource) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, resource, this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    protected IProject getProjectOrDefault(IProject project, List<IProject> projects) {
        if (project == null) {
            project = projects.stream().findFirst().orElse(null);
        }
        return project;
    }

    @Override
    public void loadResources() {
        this.loadResources(this.getConnection());
    }

    @Override
    public void loadResources(Connection newConnection) {
        if (newConnection == null) {
            return;
        }
        boolean serviceInitialized = this.resource != null;
        this.isLoaded = false;
        this.setProjects(this.loadProjects());
        super.loadResources(newConnection);
        List<com.openshift.restclient.model.IProject> openshiftProjects = ObservableTreeItemUtils.getAllModels(com.openshift.restclient.model.IProject.class, this.getResourceItems());
        this.setBuildConfigs(this.loadBuildConfigs(openshiftProjects, newConnection));
        this.setProjects(this.loadProjects());
        this.setRoutes(this.loadRoutes(this.getResourceItems()));
        this.isLoaded = true;
        if (serviceInitialized) {
            this.updateDeployProject(this.getDeployProject(this.resource), this.projects, this.resource);
        } else {
            this.updateResource((IResource)this.getService(this.deployProject, this.getResourceItems()), this.getResourceItems());
        }
        this.update(newConnection, this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.resource, this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    private List<IBuildConfig> getBuildConfigs(com.openshift.restclient.model.IProject project) {
        if (this.buildConfigsByProject == null) {
            return null;
        }
        return this.buildConfigsByProject.get(project);
    }

    protected IService getService(IProject project, List<ObservableTreeItem> services) {
        if (!ProjectUtils.isAccessible((IProject)project) || CollectionUtils.isEmpty(services)) {
            return null;
        }
        List<IService> allServices = ObservableTreeItemUtils.getAllModels(IService.class, services.stream().flatMap(ObservableTreeItemUtils::flatten).collect(Collectors.toList()));
        return allServices.stream().filter(service -> ObjectUtils.equals((Object)project, (Object)this.getDeployProject((IResource)service))).findFirst().orElse(null);
    }

    private Map<com.openshift.restclient.model.IProject, List<IBuildConfig>> loadBuildConfigs(List<com.openshift.restclient.model.IProject> projects, Connection connection) {
        if (projects == null || projects.isEmpty()) {
            return Collections.emptyMap();
        }
        return projects.stream().collect(Collectors.toMap(project -> project, project -> {
            List buildConfigs = connection.getResources("BuildConfig", project.getName());
            return buildConfigs;
        }));
    }

    private void setBuildConfigs(Map<com.openshift.restclient.model.IProject, List<IBuildConfig>> buildConfigsByProject) {
        this.buildConfigsByProject = buildConfigsByProject;
    }

    protected List<IProject> loadProjects() {
        List p = ProjectUtils.getAllAccessibleProjects();
        return p;
    }

    protected Map<com.openshift.restclient.model.IProject, List<IRoute>> loadRoutes(List<ObservableTreeItem> serviceItems) {
        List<com.openshift.restclient.model.IProject> projects = ObservableTreeItemUtils.getAllModels(com.openshift.restclient.model.IProject.class, serviceItems);
        return projects.stream().collect(Collectors.toMap(project -> project, project -> project.getResources("Route")));
    }

    public void updateServer() throws OpenShiftException {
        this.updateServer(this.server);
    }

    private void updateServer(IServerWorkingCopy server) throws OpenShiftException {
        String connectionUrl = this.getConnectionUrl((IConnection)this.getConnection());
        String serverName = OpenShiftServerUtils.getServerName((IResource)this.getResource(), (IConnection)this.getConnection());
        String host = this.getHost(this.getRoute(), (IConnection)this.getConnection());
        String routeURL = this.getRouteURL(this.isSelectDefaultRoute(), this.getRoute());
        String podPath = this.useInferredPodPath ? "" : this.podPath;
        String devmodeKey = this.getDevmodeKey(this.useImageDevmodeKey, this.devmodeKey);
        String debugPortKey = this.getDebugPortKey(this.useImageDebugPortKey, this.debugPortKey);
        String debugPortValue = this.getDebugPortValue(this.useImageDebugPortValue, this.debugPortValue);
        OpenShiftServerUtils.updateServer((String)serverName, (String)host, (String)connectionUrl, (IResource)this.getResource(), (String)this.sourcePath, (String)podPath, (IProject)this.deployProject, (String)routeURL, (String)devmodeKey, (String)debugPortKey, (String)debugPortValue, (IServerWorkingCopy)server);
        server.setAttribute("org.jboss.tools.openshift.SERVER_START_ON_CREATION", true);
        ServerProfileModel.setProfile((IServerWorkingCopy)server, (String)this.getProfileId());
        this.updateServer(connectionUrl, this.getResource(), this.sourcePath, routeURL, podPath, devmodeKey, debugPortKey, debugPortValue, this.deployProject);
        this.updateModules(server);
    }

    protected void updateServer(String connectionUrl, IResource resource, String sourcePath, String routeURL, String podPath, String devmodeKey, String debugPortKey, String debugPortValue, IProject deployProject) {
        OpenShiftServerUtils.updateServerProject((String)connectionUrl, (IResource)this.getResource(), (String)sourcePath, (String)podPath, (String)routeURL, (String)devmodeKey, (String)debugPortKey, (String)debugPortValue, (IProject)deployProject);
    }

    protected void updateModules(IServerWorkingCopy server) {
        IModule[] matchingModules = ServerUtil.getModules((IProject)this.deployProject);
        if (matchingModules != null && matchingModules.length > 0) {
            try {
                server.modifyModules(matchingModules, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                throw new OpenShiftException((Throwable)ce, "Could not get add modules to server ", new Object[]{server.getName()});
            }
        }
    }

    protected String getProfileId() {
        Collection configurationElements = ExtensionUtils.getExtensionConfigurations((String)PROFILE_DETECTOR_EP_ID);
        for (IConfigurationElement configurationElement : configurationElements) {
            try {
                IOpenshiftServerAdapterProfileDetector detector;
                Object extension = configurationElement.createExecutableExtension("class");
                if (!(extension instanceof IOpenshiftServerAdapterProfileDetector) || !(detector = (IOpenshiftServerAdapterProfileDetector)extension).detect((IConnection)this.getConnection(), this.getResource(), this.getDeployProject())) continue;
                return detector.getProfile();
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return "openshift3";
    }

    protected String getHost(IRoute route) {
        return this.getHost(route, null);
    }

    protected String getHost(IRoute route, IConnection connection) {
        if (route != null) {
            return UrlUtils.getHost((String)route.getURL());
        }
        if (connection != null) {
            return UrlUtils.getHost((String)connection.getHost());
        }
        return "";
    }

    protected String getRouteURL(boolean isSelectDefaultRoute, IRoute route) {
        if (!isSelectDefaultRoute || route == null) {
            return null;
        }
        return route.getURL();
    }

    public boolean isSelectDefaultRoute() {
        return this.selectDefaultRoute;
    }

    public void setSelectDefaultRoute(boolean selectDefaultRoute) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    protected void setRoutes(Map<com.openshift.restclient.model.IProject, List<IRoute>> routesByProject) {
        this.updateRoutes(this.resource, routesByProject);
    }

    public List<IRoute> getRoutes() {
        if (this.getResource() == null) {
            return Collections.emptyList();
        }
        return this.getRoutes(this.getResource());
    }

    protected List<IRoute> getRoutes(IResource resource) {
        if (resource instanceof IService) {
            return ResourceUtils.getRoutesFor((IService)((IService)resource), this.getAllRoutes(resource));
        }
        return Collections.emptyList();
    }

    public IRoute getRoute() {
        if (!this.isLoaded) {
            return null;
        }
        return this.route;
    }

    public void setRoute(IRoute newRoute) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), newRoute, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    protected List<IRoute> getAllRoutes(IRoute route) {
        com.openshift.restclient.model.IProject project = this.getOpenShiftProject(route);
        if (project == null) {
            return Collections.emptyList();
        }
        return this.getAllRoutes(project);
    }

    protected Map<com.openshift.restclient.model.IProject, List<IRoute>> getAllRoutes() {
        return this.routesByProject;
    }

    protected List<IRoute> getAllRoutes(IResource resource) {
        com.openshift.restclient.model.IProject project = resource.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        return this.getAllRoutes(project);
    }

    protected List<IRoute> getAllRoutes(com.openshift.restclient.model.IProject project) {
        return this.routesByProject.get(project);
    }

    protected com.openshift.restclient.model.IProject getOpenShiftProject(IRoute route) {
        return route.getProject();
    }

    public IServer saveServer(IProgressMonitor monitor) throws CoreException {
        return this.server.save(true, monitor);
    }

    protected String getConnectionUrl(IConnection connection) {
        if (connection == null) {
            return null;
        }
        try {
            ConnectionURL connectionUrl = ConnectionURL.forConnection((IConnection)connection);
            return connectionUrl.toString();
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new OpenShiftException((Throwable)e, "Could not get url for connection {0}", new Object[]{connection.getHost()});
        }
    }

    private void updateOCBinaryStatus(IStatus ocBinaryStatus) {
        this.ocBinaryStatus = ocBinaryStatus;
        this.firePropertyChange(PROPERTY_OC_BINARY_STATUS, this.ocBinaryStatus, this.ocBinaryStatus);
    }

    public IStatus getOCBinaryStatus() {
        return this.ocBinaryStatus;
    }

    public void setOCBinaryStatus(IStatus ocBinaryStatus) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    private void updateDevmode(boolean useImageDevmodeKey, String devmodeKey) {
        String oldDevmodeKey = this.devmodeKey;
        this.devmodeKey = this.getDevmodeKey(useImageDevmodeKey, devmodeKey);
        this.firePropertyChange(PROPERTY_DEVMODE_KEY, oldDevmodeKey, this.devmodeKey);
        this.useImageDevmodeKey = useImageDevmodeKey;
        this.firePropertyChange(PROPERTY_USE_IMAGE_DEVMODE_KEY, this.useImageDevmodeKey, this.useImageDevmodeKey);
    }

    public void setUseImageDevmodeKey(boolean useImageDevmodeKey) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    public boolean isUseImageDevmodeKey() {
        return this.useImageDevmodeKey;
    }

    protected boolean isUseImageDevmodeKey(String devmodeKey) {
        return StringUtils.isEmpty((String)devmodeKey);
    }

    public void setDevmodeKey(String devmodeKey) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    public String getDevmodeKey() {
        return this.devmodeKey;
    }

    private String getDevmodeKey(boolean useImageDevmodeKey, String devmodeKey) {
        if (useImageDevmodeKey) {
            devmodeKey = null;
        }
        return devmodeKey;
    }

    public void setUseImageDebugPortKey(boolean useImageDebugPortKey) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    public boolean isUseImageDebugPortKey() {
        return this.useImageDebugPortKey;
    }

    protected boolean isUseImageDebugPortKey(String debugPortKey) {
        return StringUtils.isEmpty((String)debugPortKey);
    }

    public void setDebugPortKey(String debugPortKey) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, debugPortKey, this.useImageDebugPortValue, this.debugPortValue);
    }

    public String getDebugPortKey() {
        return this.debugPortKey;
    }

    private String getDebugPortKey(boolean useImageDebugPortKey, String debugPortKey) {
        if (useImageDebugPortKey) {
            return null;
        }
        return debugPortKey;
    }

    public void setUseImageDebugPortValue(boolean useImageDebugPortValue) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, useImageDebugPortValue, this.debugPortValue);
    }

    public boolean isUseImageDebugPortValue() {
        return this.useImageDebugPortValue;
    }

    protected boolean isUseImageDebugPortValue(String debugPortValue) {
        return StringUtils.isEmpty((String)debugPortValue);
    }

    public void setDebugPortValue(String debugPortValue) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, this.podPath, this.useInferredPodPath, this.getResource(), this.getResourceItems(), this.route, this.selectDefaultRoute, this.routesByProject, this.ocBinaryStatus, this.useImageDevmodeKey, this.devmodeKey, this.useImageDebugPortKey, this.debugPortKey, this.useImageDebugPortValue, debugPortValue);
    }

    public String getDebugPortValue() {
        return this.debugPortValue;
    }

    private String getDebugPortValue(boolean useImageDebugPortValue, String debugPortValue) {
        if (useImageDebugPortValue) {
            return null;
        }
        return debugPortValue;
    }

    private void updateDebugPort(boolean useImageDebugPortKey, String debugPortKey, boolean useImageDebugPortValue, String debugPortValue) {
        String oldDebugPortKey = this.debugPortKey;
        this.debugPortKey = this.getDebugPortKey(useImageDebugPortKey, debugPortKey);
        String oldDebugPort = this.debugPortValue;
        this.debugPortValue = this.getDebugPortValue(useImageDebugPortValue, debugPortValue);
        this.firePropertyChange(PROPERTY_DEBUG_PORT_KEY, oldDebugPortKey, this.debugPortKey);
        this.firePropertyChange(PROPERTY_DEBUG_PORT_VALUE, oldDebugPort, this.debugPortValue);
        this.useImageDebugPortKey = useImageDebugPortKey;
        this.firePropertyChange(PROPERTY_USE_IMAGE_DEBUG_PORT_KEY, this.useImageDebugPortKey, this.useImageDebugPortKey);
        this.useImageDebugPortValue = useImageDebugPortValue;
        this.firePropertyChange(PROPERTY_USE_IMAGE_DEBUG_PORT_VALUE, this.useImageDebugPortValue, this.useImageDebugPortValue);
    }

    protected IServerWorkingCopy getServer() {
        return this.server;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        boolean[] needReload = new boolean[1];
        try {
            event.getDelta().accept(delta -> {
                if (delta.getResource().getType() == 4 && (delta.getKind() == 1 || delta.getKind() == 2)) {
                    blArray[0] = true;
                }
                return true;
            }, true);
            if (needReload[0]) {
                this.setProjects(this.loadProjects());
            }
        }
        catch (CoreException e) {
            OpenShiftUIActivator.log(4, e.getLocalizedMessage(), e);
        }
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }
}

