/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.utils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class ObservableTreeItemUtils {
    public static Stream<ObservableTreeItem> flatten(ObservableTreeItem treeItem) {
        return Stream.concat(Stream.of(treeItem), treeItem.getChildren().stream().flatMap(ObservableTreeItemUtils::flatten));
    }

    public static boolean contains(Object targetModel, List<ObservableTreeItem> items) {
        if (items == null || items.isEmpty() || targetModel == null) {
            return false;
        }
        return items.stream().flatMap(ObservableTreeItemUtils::flatten).anyMatch(item -> targetModel.equals(item.getModel()));
    }

    public static ObservableTreeItem getItemFor(Object model, List<ObservableTreeItem> items) {
        if (items == null || model == null) {
            return null;
        }
        Optional<ObservableTreeItem> item = items.stream().filter(i -> Objects.equals(model, i.getModel())).findFirst();
        if (item.isPresent()) {
            return item.get();
        }
        return null;
    }

    public static <T> List<T> getAllModels(Class<? extends T> type, List<ObservableTreeItem> items) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        return items.stream().filter(item -> {
            Object model = item.getModel();
            return model != null && type.isAssignableFrom(model.getClass());
        }).map(child -> child.getModel()).collect(Collectors.toList());
    }

    public static <T> T getFirstModel(Class<? extends T> type, List<ObservableTreeItem> items) {
        if (items == null) {
            return null;
        }
        return (T)items.stream().flatMap(ObservableTreeItemUtils::flatten).filter(item -> item.getModel() != null && (type == null || type.isAssignableFrom(item.getModel().getClass()))).map(item -> item.getModel()).findFirst().orElseGet(() -> null);
    }
}

