/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.utils;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class SSLCertificateUtils {
    public static final String BEGIN_CERTIFICATE_MARKER = "-----BEGIN CERTIFICATE-----\n";
    public static final String END_CERTIFICATE_MARKER = "-----END CERTIFICATE-----";
    public static final String CERTIFICATE_FACTORY_X509 = "X.509";

    private SSLCertificateUtils() {
    }

    public static X509Certificate createX509Certificate(String certificateString) throws CertificateException {
        if (StringUtils.isEmpty((String)certificateString)) {
            return null;
        }
        CertificateFactory factory = CertificateFactory.getInstance(CERTIFICATE_FACTORY_X509);
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificateString.getBytes()));
    }

    public static String toString(X509Certificate certificate) throws CertificateEncodingException {
        StringBuilder sb = new StringBuilder().append(BEGIN_CERTIFICATE_MARKER).append(Base64.getEncoder().encodeToString(certificate.getEncoded())).append(END_CERTIFICATE_MARKER);
        return sb.toString();
    }
}

