/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class EnvironmentVarKeyValidator
implements IValidator {
    private static final Pattern CIDENTIFIER_REGEXP = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");
    private final String failureMessage = "A valid {0} is alphanumeric (a-z, and 0-9), including the character '_', allowed anywhere except first position.";
    private final IStatus FAILED;
    private static final IStatus NAME_IS_USED_ERROR = ValidationStatus.error((String)"An environment variable with this name already exists");
    private Collection<String> usedKeys;

    public EnvironmentVarKeyValidator(Collection<String> usedKeys) {
        this("environment variable name", usedKeys);
    }

    public EnvironmentVarKeyValidator(String element, Collection<String> usedKeys) {
        this.FAILED = ValidationStatus.error((String)NLS.bind((String)"A valid {0} is alphanumeric (a-z, and 0-9), including the character '_', allowed anywhere except first position.", (Object)element));
        this.usedKeys = usedKeys != null ? usedKeys : new ArrayList(0);
    }

    public IStatus validate(Object paramObject) {
        if (!(paramObject instanceof String)) {
            return ValidationStatus.cancel((String)"Value is not an instance of a string");
        }
        String value = (String)paramObject;
        if (StringUtils.isBlank((String)value)) {
            return ValidationStatus.cancel((String)"Please provide a key name.");
        }
        if (!CIDENTIFIER_REGEXP.matcher(value).matches()) {
            return this.FAILED;
        }
        if (this.usedKeys.contains(value)) {
            return NAME_IS_USED_ERROR;
        }
        return ValidationStatus.OK_STATUS;
    }
}

