/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class GitReferenceValidator
extends MultiValidator
implements IValidator {
    private static final Map<Character, Integer> charactersToExclusionRule = new HashMap<Character, Integer>();
    private static final Map<Character, Character> twoCharacterSequences = new HashMap<Character, Character>();
    private IObservableValue<String> observable;

    static {
        twoCharacterSequences.put(Character.valueOf('.'), Character.valueOf('.'));
        int i = 0;
        while (i < 32) {
            charactersToExclusionRule.put(Character.valueOf((char)i), 4);
            ++i;
        }
        String rule4chars = "\u00b1 ~^:";
        int i2 = 0;
        while (i2 < rule4chars.length()) {
            charactersToExclusionRule.put(Character.valueOf(rule4chars.charAt(i2)), 4);
            ++i2;
        }
        String rule5chars = "?*[";
        int i3 = 0;
        while (i3 < rule5chars.length()) {
            charactersToExclusionRule.put(Character.valueOf(rule5chars.charAt(i3)), 5);
            ++i3;
        }
        twoCharacterSequences.put(Character.valueOf('/'), Character.valueOf('/'));
        twoCharacterSequences.put(Character.valueOf('@'), Character.valueOf('{'));
        charactersToExclusionRule.put(Character.valueOf('\\'), 10);
    }

    public GitReferenceValidator(IObservableValue<String> observable) {
        this.observable = observable;
    }

    public GitReferenceValidator() {
    }

    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return ValidationStatus.OK_STATUS;
        }
        String ref = (String)value;
        if (StringUtils.isBlank((String)ref)) {
            return ValidationStatus.OK_STATUS;
        }
        int i = 0;
        while (i < ref.length()) {
            char c = ref.charAt(i);
            Integer rule = charactersToExclusionRule.get(Character.valueOf(c));
            if (rule != null) {
                return ValidationStatus.error((String)("Reference cannot contain character '" + c + "'"));
            }
            Character next = twoCharacterSequences.get(Character.valueOf(c));
            if (next != null && i + 1 < ref.length() && next.charValue() == ref.charAt(i + 1)) {
                return ValidationStatus.error((String)("Reference cannot contain sequence '" + c + next + "'"));
            }
            ++i;
        }
        if (ref.startsWith("/") || ref.endsWith("/")) {
            return ValidationStatus.error((String)"Reference cannot begin or end with '/'");
        }
        if (ref.endsWith(".")) {
            return ValidationStatus.error((String)"Reference cannot end with a dot");
        }
        if (ref.equals("@")) {
            return ValidationStatus.error((String)"Reference cannot be a single character '@'");
        }
        String[] stringArray = ref.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.startsWith(".")) {
                return ValidationStatus.error((String)"Reference or its slash-separated component cannot start with a dot");
            }
            if (part.endsWith(".lock")) {
                return ValidationStatus.error((String)"Reference or its slash-separated component cannot end with '.lock'");
            }
            ++n2;
        }
        return ValidationStatus.OK_STATUS;
    }

    protected IStatus validate() {
        if (this.observable == null) {
            return ValidationStatus.OK_STATUS;
        }
        return this.validate(this.observable.getValue());
    }
}

