/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class LabelValueValidator
implements IValidator {
    public static final int LABEL_MAXLENGTH = 63;
    private static final Pattern LABEL_REGEXP = Pattern.compile("^(([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9])?$");
    public static final String valueDescription = "A valid {0} must be 63 characters or less\nand must begin and end with an alphanumeric character ([a-z0-9A-Z]),\nwith dashes (-), underscores (_), dots (.), and alphanumerics between.";
    public static final String defaultType = "label value";
    private final IStatus FAILED;
    protected String type;

    protected static boolean isAlphaNumeric(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    protected static boolean isAlphaNumericOrValueSeparator(char c) {
        return LabelValueValidator.isAlphaNumeric(c) || c == '.' || c == '-' || c == '_';
    }

    public LabelValueValidator() {
        this(defaultType);
    }

    public LabelValueValidator(String element) {
        this.type = element;
        this.FAILED = ValidationStatus.error((String)NLS.bind((String)valueDescription, (Object)this.type));
    }

    public IStatus validate(Object paramObject) {
        if (!(paramObject instanceof String)) {
            return ValidationStatus.cancel((String)this.getValueIsNotAStringMessage());
        }
        String value = (String)paramObject;
        if (StringUtils.isBlank((String)value)) {
            return ValidationStatus.cancel((String)NLS.bind((String)"{0} is required.", (Object)this.type));
        }
        if (value.length() > 63) {
            return this.getSizeConstraintError();
        }
        if (!LABEL_REGEXP.matcher(value).matches()) {
            return this.getLabelRegexError(value, this.type);
        }
        return ValidationStatus.OK_STATUS;
    }

    protected String getValueIsNotAStringMessage() {
        return NLS.bind((String)"{0} is not an instance of a string", (Object)this.type);
    }

    protected IStatus getLabelRegexError(String value, String type) {
        if (!LabelValueValidator.isAlphaNumeric(value.charAt(0))) {
            return ValidationStatus.error((String)NLS.bind((String)"A valid {0} must begin with an alphanumeric character", (Object)type));
        }
        if (value.length() > 2) {
            int i = 1;
            while (i < value.length() - 1) {
                if (!LabelValueValidator.isAlphaNumericOrValueSeparator(value.charAt(i))) {
                    return ValidationStatus.error((String)NLS.bind((String)"A character ''{0}'' is not allowed in {1}", (Object)value.substring(i, i + 1), (Object)type));
                }
                ++i;
            }
        }
        if (value.length() > 1 && !LabelValueValidator.isAlphaNumeric(value.charAt(value.length() - 1))) {
            return ValidationStatus.error((String)NLS.bind((String)"A valid {0} must end with an alphanumeric character", (Object)type));
        }
        return ValidationStatus.error((String)NLS.bind((String)"{0} is not valid.", (Object)type));
    }

    protected boolean validateLabel(String value) {
        if (value.length() > 63) {
            return false;
        }
        return LABEL_REGEXP.matcher(value).matches();
    }

    protected IStatus getSizeConstraintError() {
        return ValidationStatus.error((String)NLS.bind((String)"Maximum length allowed is {0} characters for {1}", (Object)63, (Object)this.type));
    }

    protected IStatus getPatternConstraintError() {
        return this.getFailedStatus();
    }

    protected IStatus getFailedStatus() {
        return this.FAILED;
    }
}

