/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class OpenShiftIdentifierValidator
implements IValidator {
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[A-Za-z_][A-Za-z0-9_]*");

    public IStatus validate(Object value) {
        if (!(value instanceof String) || StringUtils.isEmpty((String)((String)value))) {
            return ValidationStatus.error((String)"Please provide an alphanumeric identifier.");
        }
        if (!IDENTIFIER_PATTERN.matcher((String)value).matches()) {
            return ValidationStatus.error((String)"Please provide an identier that starts with alphabetic character or '_', followed by a string of alphanumeric characters or '_'");
        }
        return ValidationStatus.ok();
    }
}

