/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class ProjectDisplayNameValidator
implements IValidator {
    public static final int DISPLAY_NAME_LENGTH_LIMIT = 65535;

    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return ValidationStatus.cancel((String)"Display name is not an instance of a string");
        }
        String param = (String)value;
        if (StringUtils.isNotEmpty((String)param)) {
            if (param.indexOf(9) >= 0 || param.indexOf(10) >= 0) {
                return ValidationStatus.error((String)"Display name may not contain tabs or new lines");
            }
            if (param.length() > 65535) {
                return ValidationStatus.error((String)"Display name may not be longer than 65535 characters");
            }
        }
        return ValidationStatus.ok();
    }
}

