/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class ServiceNameValidator
implements IValidator {
    private static final String CHAR_FMT = "[a-z0-9]";
    private static final String EXT_CHAR_FMT = "[-a-z0-9]";
    public static final int MAXLENGTH = 24;
    private static final Pattern REGEX = Pattern.compile("^[a-z]([-a-z0-9]*[a-z0-9])?$");
    private static final String failureMessage = "A valid name is alphanumeric (a-z, and 0-9), with the character '-' allowed anywhere except first or last position.";
    private final IStatus FAILED = ValidationStatus.error((String)"A valid name is alphanumeric (a-z, and 0-9), with the character '-' allowed anywhere except first or last position.");
    private final IStatus EMPTY_CANCEL = ValidationStatus.cancel((String)"Please provide a valid resource name.");

    public IStatus validate(Object paramObject) {
        if (paramObject != null && !(paramObject instanceof String)) {
            return ValidationStatus.cancel((String)"Name is not an instance of a string");
        }
        String value = (String)paramObject;
        if (StringUtils.isBlank((String)value)) {
            return this.EMPTY_CANCEL;
        }
        if (value.length() > 24) {
            return ValidationStatus.error((String)NLS.bind((String)"Maximum name length is {0} characters", (Object)24));
        }
        if (!REGEX.matcher(value).matches()) {
            return this.FAILED;
        }
        return ValidationStatus.OK_STATUS;
    }
}

