/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.webhooks;

import com.openshift.restclient.model.IBuildConfig;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.openshift.internal.ui.webhooks.WebHooksComponent;

public class WebHooksDialog
extends Dialog {
    private Collection<IBuildConfig> buildConfigs;

    public WebHooksDialog(Shell parent, IBuildConfig buildConfig) {
        super(parent);
        this.buildConfigs = Collections.singleton(buildConfig);
    }

    public WebHooksDialog(Shell parent, Collection<IBuildConfig> buildConfigs) {
        super(parent);
        this.buildConfigs = buildConfigs;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Webhooks triggers");
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        WebHooksComponent webHookComponent = new WebHooksComponent(this.buildConfigs, container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(500, -1).applyTo((Control)webHookComponent);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

