/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.common;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueItem;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueWizardModel;
import org.jboss.tools.openshift.internal.common.ui.wizard.KeyValueWizard;
import org.jboss.tools.openshift.internal.common.ui.wizard.KeyValueWizardModelBuilder;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.ui.validator.EnvironmentVarKeyValidator;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariable;
import org.jboss.tools.openshift.internal.ui.wizard.common.IEnvironmentVariablesPageModel;

public abstract class EnvironmentVariablePage
extends AbstractOpenShiftWizardPage {
    private static final String ENVIRONMENT_VARIABLE_LABEL = "Environment Variable";
    private static final String ENVIRONMENT_VARIABLE_KEY_LABEL = "Name";
    public static final String TABLE_LABEL = "Environment variables:";
    public static final String TABLE_LABEL_TOOLTIP = "Environment variables are passed to running pods for consumption by the pod containers";
    private IEnvironmentVariablesPageModel model;
    private TableViewer envViewer;
    protected int heightScale = 30;
    protected Composite envTableContainer;
    protected boolean canDeleteAnyVar = false;

    protected EnvironmentVariablePage(String title, String description, String name, IWizard wizard, IEnvironmentVariablesPageModel model) {
        super(title, description, name, wizard);
        this.model = model;
    }

    protected void createEnvVariableControl(Composite parent, DataBindingContext dbc) {
        this.createEnvVariableControl(parent, dbc, TABLE_LABEL, TABLE_LABEL_TOOLTIP);
    }

    protected void createEnvVariableControl(Composite parent, DataBindingContext dbc, String label, String tooltip) {
        Composite envContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)envContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(2, 2).applyTo(envContainer);
        Label lblEnvVars = new Label(envContainer, 0);
        lblEnvVars.setText(label);
        lblEnvVars.setToolTipText(tooltip);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).applyTo((Control)lblEnvVars);
        Composite tableContainer = this.envTableContainer = new Composite(envContainer, 0);
        this.envViewer = this.createEnvVarTable(tableContainer);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).hint(-1, 150).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.envViewer)).to(BeanProperties.value((String)"selectedEnvironmentVariable").observe((Object)this.model)).in(dbc);
        this.envViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.envViewer.setInput((Object)BeanProperties.list((String)"environmentVariables").observe((Object)this.model));
        Button addButton = new Button(envContainer, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)addButton);
        addButton.setText("Add...");
        addButton.setToolTipText("Add an environment variable declared by the docker image.");
        addButton.addSelectionListener(this.onAdd());
        UIUtils.setDefaultButtonWidth((Button)addButton);
        this.heightScale = addButton.computeSize((int)-1, (int)-1).y;
        Button editExistingButton = new Button(envContainer, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)editExistingButton);
        editExistingButton.setText("Edit...");
        editExistingButton.setToolTipText("Edit the environment variable declared by the docker image.");
        editExistingButton.addSelectionListener((SelectionListener)new EditHandler());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)editExistingButton)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedEnvironmentVariable").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        UIUtils.setDefaultButtonWidth((Button)editExistingButton);
        Button btnReset = new Button(envContainer, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)btnReset);
        btnReset.setText("Reset");
        btnReset.setToolTipText("Reset to the value declared by the docker image.");
        btnReset.addSelectionListener(this.onResetEnvVar());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnReset)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedEnvironmentVariable").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter(){

            public Object convert(Object fromObject) {
                Boolean notNull = (Boolean)super.convert(fromObject);
                if (notNull.booleanValue() && !((EnvironmentVariable)fromObject).isNew() && EnvironmentVariablePage.this.model.isEnvironmentVariableModified((EnvironmentVariable)fromObject)) {
                    return true;
                }
                return false;
            }
        })).in(dbc);
        UIUtils.setDefaultButtonWidth((Button)btnReset);
        Button btnResetAll = new Button(envContainer, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)btnResetAll);
        btnResetAll.setText("Reset All");
        btnResetAll.setToolTipText("Reset all variables to the value declared by the docker image.");
        btnResetAll.addSelectionListener(this.onResetEnvVars());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnResetAll)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedEnvironmentVariable").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter(){

            public Object convert(Object fromObject) {
                List<EnvironmentVariable> vars = EnvironmentVariablePage.this.model.getEnvironmentVariables();
                if (vars != null && !vars.isEmpty() && vars.stream().anyMatch(v -> !v.isNew() && EnvironmentVariablePage.this.model.isEnvironmentVariableModified((EnvironmentVariable)v))) {
                    return true;
                }
                return false;
            }
        })).in(dbc);
        UIUtils.setDefaultButtonWidth((Button)btnResetAll);
        Button btnRemove = new Button(envContainer, 8);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)btnRemove);
        btnRemove.setText("Remove");
        btnRemove.setToolTipText("Remove the environment variable added here.");
        btnRemove.addSelectionListener(this.onRemoveEnvVar());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnRemove)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedEnvironmentVariable").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter(){

            public Object convert(Object fromObject) {
                Boolean notNull = (Boolean)super.convert(fromObject);
                if (notNull.booleanValue() && (EnvironmentVariablePage.this.canDeleteAnyVar || ((EnvironmentVariable)fromObject).isNew()) && !EnvironmentVariablePage.this.model.isEnvironmentVariableDeleted((EnvironmentVariable)fromObject)) {
                    return true;
                }
                return false;
            }
        })).in(dbc);
        UIUtils.setDefaultButtonWidth((Button)btnRemove);
    }

    private SelectionListener onResetEnvVar() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVariable envVar = (EnvironmentVariable)UIUtils.getFirstElement((ISelection)EnvironmentVariablePage.this.envViewer.getSelection(), EnvironmentVariable.class);
                if (MessageDialog.openQuestion((Shell)EnvironmentVariablePage.this.getShell(), (String)"Reset Environment Variable", (String)NLS.bind((String)"Are you sure you want to reset the {0} {1}?", (Object)EnvironmentVariablePage.ENVIRONMENT_VARIABLE_LABEL.toLowerCase(), (Object)envVar.getKey()))) {
                    String key = envVar.getKey();
                    EnvironmentVariablePage.this.model.resetEnvironmentVariable(envVar);
                    EnvironmentVariablePage.this.selectEnvVarByKey(key);
                }
            }
        };
    }

    private SelectionListener onResetEnvVars() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<EnvironmentVariable> vars = EnvironmentVariablePage.this.model.getEnvironmentVariables();
                EnvironmentVariable envVar = (EnvironmentVariable)UIUtils.getFirstElement((ISelection)EnvironmentVariablePage.this.envViewer.getSelection(), EnvironmentVariable.class);
                if (MessageDialog.openQuestion((Shell)EnvironmentVariablePage.this.getShell(), (String)"Reset Environment Variable", (String)NLS.bind((String)"Are you sure you want to reset all {0}s?", (Object)EnvironmentVariablePage.ENVIRONMENT_VARIABLE_LABEL.toLowerCase()))) {
                    vars.stream().forEach(v -> EnvironmentVariablePage.this.model.resetEnvironmentVariable((EnvironmentVariable)v));
                    if (envVar != null) {
                        EnvironmentVariablePage.this.selectEnvVarByKey(envVar.getKey());
                    }
                }
            }
        };
    }

    private SelectionListener onRemoveEnvVar() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVariable envVar = (EnvironmentVariable)UIUtils.getFirstElement((ISelection)EnvironmentVariablePage.this.envViewer.getSelection(), EnvironmentVariable.class);
                if (MessageDialog.openQuestion((Shell)EnvironmentVariablePage.this.getShell(), (String)"Remove Environment Variable", (String)NLS.bind((String)"Are you sure you want to remove the {0} {1}?", (Object)EnvironmentVariablePage.ENVIRONMENT_VARIABLE_LABEL.toLowerCase(), (Object)envVar.getKey()))) {
                    EnvironmentVariablePage.this.model.removeEnvironmentVariable(envVar);
                    EnvironmentVariablePage.this.envViewer.refresh();
                }
            }
        };
    }

    private SelectionListener onAdd() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set<String> usedKeys = EnvironmentVariablePage.this.model.getEnvironmentVariables().stream().filter(v -> !EnvironmentVariablePage.this.model.isEnvironmentVariableDeleted((IKeyValueItem)v)).map(v -> v.getKey()).collect(Collectors.toSet());
                IKeyValueWizardModel dialogModel = new KeyValueWizardModelBuilder().windowTitle(EnvironmentVariablePage.ENVIRONMENT_VARIABLE_LABEL).title("Add Environment Variable").description(NLS.bind((String)"Add an {0}.", (Object)EnvironmentVariablePage.ENVIRONMENT_VARIABLE_LABEL.toLowerCase())).keyLabel(EnvironmentVariablePage.ENVIRONMENT_VARIABLE_KEY_LABEL).groupLabel(EnvironmentVariablePage.ENVIRONMENT_VARIABLE_LABEL).keyAfterConvertValidator((IValidator)new EnvironmentVarKeyValidator(usedKeys)).build();
                OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog(EnvironmentVariablePage.this.getShell(), (IWizard)new KeyValueWizard(dialogModel));
                if (dialog.open() == 0) {
                    EnvironmentVariablePage.this.model.addEnvironmentVariable(dialogModel.getKey(), dialogModel.getValue());
                    EnvironmentVariablePage.this.selectEnvVarByKey(dialogModel.getKey());
                }
            }
        };
    }

    private void selectEnvVarByKey(String key) {
        EnvironmentVariable envVar = this.model.getEnvironmentVariable(key);
        if (envVar != null) {
            this.envViewer.setSelection((ISelection)new StructuredSelection((Object)envVar));
            this.envViewer.reveal((Object)envVar);
        }
    }

    protected TableViewer createEnvVarTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.envViewer = new TableViewerBuilder(table, tableContainer).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IKeyValueItem>(){

            public String getValue(IKeyValueItem label) {
                boolean isDeleted = EnvironmentVariablePage.this.model.isEnvironmentVariableDeleted(label);
                return !isDeleted ? label.getKey() : "[deleted] " + label.getKey();
            }

            public boolean isModified(IKeyValueItem e) {
                return ((EnvironmentVariable)e).isNew() || EnvironmentVariablePage.this.model.isEnvironmentVariableDeleted(e);
            }
        }).name(ENVIRONMENT_VARIABLE_KEY_LABEL).align(16384).weight(2).minWidth(75).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IKeyValueItem>(){

            public String getValue(IKeyValueItem label) {
                if (EnvironmentVariablePage.this.model.isEnvironmentVariableDeleted(label)) {
                    return "";
                }
                return label.getValue();
            }

            public boolean isModified(IKeyValueItem e) {
                return EnvironmentVariablePage.this.model.isEnvironmentVariableModified((EnvironmentVariable)e);
            }
        }).name("Value").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        this.envViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IKeyValueItem first = (IKeyValueItem)e1;
                IKeyValueItem other = (IKeyValueItem)e2;
                return first.getKey().compareTo(other.getKey());
            }
        });
        this.envViewer.addDoubleClickListener((IDoubleClickListener)new EditHandler());
        return this.envViewer;
    }

    private class EditHandler
    extends SelectionAdapter
    implements IDoubleClickListener {
        private EditHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleEvent();
        }

        public void doubleClick(DoubleClickEvent event) {
            this.handleEvent();
        }

        private void handleEvent() {
            EnvironmentVariable var = (EnvironmentVariable)UIUtils.getFirstElement((ISelection)EnvironmentVariablePage.this.envViewer.getSelection(), EnvironmentVariable.class);
            Set<String> usedKeys = EnvironmentVariablePage.this.model.getEnvironmentVariables().stream().filter(v -> !EnvironmentVariablePage.this.model.isEnvironmentVariableDeleted((IKeyValueItem)v)).map(v -> v.getKey()).collect(Collectors.toSet());
            usedKeys.remove(var.getKey());
            EnvironmentVariable copy = new EnvironmentVariable(var.getKey(), EnvironmentVariablePage.this.model.isEnvironmentVariableDeleted(var) ? "" : var.getValue(), var.isNew());
            IKeyValueWizardModel dialogModel = new KeyValueWizardModelBuilder((IKeyValueItem)copy).windowTitle(EnvironmentVariablePage.ENVIRONMENT_VARIABLE_LABEL).title("Edit Environment Variable").description(NLS.bind((String)"Edit the {0}.", (Object)EnvironmentVariablePage.ENVIRONMENT_VARIABLE_LABEL.toLowerCase())).keyLabel(EnvironmentVariablePage.ENVIRONMENT_VARIABLE_KEY_LABEL).editableKey(var.isNew() || EnvironmentVariablePage.this.canDeleteAnyVar).groupLabel(EnvironmentVariablePage.ENVIRONMENT_VARIABLE_LABEL).keyAfterConvertValidator((IValidator)new EnvironmentVarKeyValidator(usedKeys)).build();
            OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog(EnvironmentVariablePage.this.getShell(), (IWizard)new KeyValueWizard((IKeyValueItem)var, dialogModel));
            if (dialog.open() == 0) {
                EnvironmentVariablePage.this.model.updateEnvironmentVariable(var, dialogModel.getKey(), dialogModel.getValue());
                EnvironmentVariablePage.this.selectEnvVarByKey(dialogModel.getKey());
            }
        }
    }
}

