/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.connection;

import org.apache.commons.lang.BooleanUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.DataBindingUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.NewConnectionMarker;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredStringValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimmingStringConverter;
import org.jboss.tools.openshift.internal.common.ui.detailviews.BaseDetailsView;
import org.jboss.tools.openshift.internal.ui.wizard.connection.ConnectionValidatorFactory;
import org.jboss.tools.openshift.internal.ui.wizard.connection.IConnectionEditorDetailView;

public class BasicAuthenticationDetailView
extends BaseDetailsView
implements IConnectionEditorDetailView {
    private ConnectionWizardPageModel pageModel;
    IObservableValue<?> urlObservable;
    private Text usernameText;
    private IObservableValue usernameObservable;
    private Binding usernameBinding;
    private Text passwordText;
    private IObservableValue passwordObservable;
    private Binding passwordBinding;
    private IObservableValue rememberPasswordObservable;
    private IValueChangeListener changeListener;
    private ConnectionWizardPageModel.IConnectionAuthenticationProvider connectionAuthProvider;
    private Button rememberPasswordCheckbox;
    private Binding rememberPasswordBinding;
    private MultiValidator connectionValidator;

    public BasicAuthenticationDetailView(ConnectionWizardPageModel pageModel, IValueChangeListener changeListener, Object context) {
        this.changeListener = changeListener;
        this.pageModel = pageModel;
        this.urlObservable = BeanProperties.value((String)"host").observe((Object)pageModel);
        this.usernameObservable = new WritableValue(null, String.class);
        this.connectionValidator = ConnectionValidatorFactory.createBasicAuthenticationValidator(pageModel, this.usernameObservable, this.urlObservable);
    }

    public final Text getUsernameTextControl() {
        return this.usernameText;
    }

    public final Text getPasswordTextControl() {
        return this.passwordText;
    }

    public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
        Composite composite = this.setControl(new Composite(parent, 0));
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).spacing(10, 10).applyTo(composite);
        Label usernameLabel = new Label(composite, 0);
        usernameLabel.setText("&Username:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)usernameLabel);
        this.usernameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.usernameText);
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText("&Password:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)passwordLabel);
        this.passwordText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.passwordText);
        this.passwordObservable = new WritableValue(null, String.class);
        this.rememberPasswordObservable = new WritableValue((Object)Boolean.FALSE, Boolean.class);
        this.rememberPasswordCheckbox = new Button(composite, 32);
        this.rememberPasswordCheckbox.setText("&Save password (could trigger secure storage login)");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.rememberPasswordCheckbox);
        return composite;
    }

    public boolean isViewFor(Object object) {
        return object == this;
    }

    public void onVisible(IObservableValue detailsViewModel, DataBindingContext dbc) {
        dbc.addValidationStatusProvider((ValidationStatusProvider)this.connectionValidator);
        this.bindWidgetsToInternalModel(dbc);
        this.rememberPasswordBinding = ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)this.rememberPasswordCheckbox)).to(this.rememberPasswordObservable).in(dbc);
    }

    @Override
    public void setSelectedConnection(IConnection conn) {
        if (conn instanceof Connection) {
            Connection selectedConnection = (Connection)conn;
            this.usernameObservable.setValue((Object)selectedConnection.getUsername());
            this.passwordObservable.setValue((Object)selectedConnection.getPassword());
            this.rememberPasswordObservable.setValue((Object)selectedConnection.isRememberPassword());
        } else if (conn instanceof NewConnectionMarker) {
            this.usernameObservable.setValue(null);
            this.passwordObservable.setValue(null);
        }
    }

    public void onInVisible(IObservableValue detailsViewModel, DataBindingContext dbc) {
        this.disposeBindings();
        org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils.dispose((ValidationStatusProvider)this.rememberPasswordBinding);
        dbc.removeValidationStatusProvider((ValidationStatusProvider)this.connectionValidator);
    }

    private void bindWidgetsToInternalModel(DataBindingContext dbc) {
        this.usernameBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.usernameText)).converting((IConverter)new TrimmingStringConverter())).validatingAfterConvert((IValidator)new RequiredStringValidator("v3 username"))).to(this.usernameObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)this.usernameBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        DataBindingUtils.addDisposableValueChangeListener((IValueChangeListener)this.changeListener, (IObservableValue)this.usernameObservable, (Control)this.usernameText);
        this.passwordBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.passwordText)).converting((IConverter)new TrimmingStringConverter())).validatingAfterConvert((IValidator)new RequiredStringValidator("v3 password"))).to(this.passwordObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)this.passwordBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        DataBindingUtils.addDisposableValueChangeListener((IValueChangeListener)this.changeListener, (IObservableValue)this.passwordObservable, (Control)this.passwordText);
        this.connectionAuthProvider = new ConnectionAuthenticationProvider();
    }

    public void dispose() {
        this.disposeBindings();
    }

    private void disposeBindings() {
        org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils.dispose((ValidationStatusProvider)this.usernameBinding);
        org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils.dispose((ValidationStatusProvider)this.passwordBinding);
    }

    @Override
    public ConnectionWizardPageModel.IConnectionAuthenticationProvider getConnectionAuthenticationProvider() {
        return this.connectionAuthProvider;
    }

    public String toString() {
        return "Basic";
    }

    private class ConnectionAuthenticationProvider
    implements ConnectionWizardPageModel.IConnectionAuthenticationProvider {
        private ConnectionAuthenticationProvider() {
        }

        public IConnection update(IConnection conn) {
            Assert.isLegal((boolean)(conn instanceof Connection));
            final Connection connection = (Connection)conn;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    connection.setAuthScheme("Basic");
                    connection.setUsername((String)BasicAuthenticationDetailView.this.usernameObservable.getValue());
                    connection.setPassword((String)BasicAuthenticationDetailView.this.passwordObservable.getValue());
                    connection.setRememberPassword(BooleanUtils.toBoolean((Boolean)((Boolean)BasicAuthenticationDetailView.this.rememberPasswordObservable.getValue())));
                }
            });
            return connection;
        }
    }
}

