/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IProject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.conversion.ObjectToStringConverter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.docker.ui.wizards.ImageSearch;
import org.eclipse.linuxtools.internal.docker.core.RegistryInfo;
import org.eclipse.linuxtools.internal.docker.ui.wizards.NewDockerConnection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionColumLabelProvider;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimmingStringConverter;
import org.jboss.tools.openshift.internal.common.ui.job.UIUpdatingJob;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.comparators.ProjectViewerComparator;
import org.jboss.tools.openshift.internal.ui.explorer.OpenShiftExplorerLabelProvider;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItemLabelProvider;
import org.jboss.tools.openshift.internal.ui.validator.DockerImageValidator;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceNameControl;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImagePageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ListDockerImagesWizard;
import org.jboss.tools.openshift.internal.ui.wizard.project.NewProjectWizard;

public class DeployImagePage
extends AbstractOpenShiftWizardPage {
    private static final String MISSING_DOCKER_CONNECTION_MSG = "You must select a Docker connection.";
    static String DEPLOY_IMAGE_PAGE_NAME = "Deployment Config Settings Page";
    private static final String PAGE_DESCRIPTION = "This page allows you to choose an image and the name to be used for the deployed resources.";
    private static final int NUM_COLUMS = 4;
    private final IDeployImagePageModel model;
    ContentProposalAdapter imageNameProposalAdapter;

    protected DeployImagePage(IWizard wizard, IDeployImagePageModel model) {
        super("Deploy an Image", PAGE_DESCRIPTION, DEPLOY_IMAGE_PAGE_NAME, wizard);
        this.model = model;
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }

    protected void onPageWillGetDeactivated(AbstractOpenShiftWizardPage.Direction progress, PageChangingEvent event, DataBindingContext dbc) {
        if (this.imageNameProposalAdapter != null) {
            this.imageNameProposalAdapter.setEnabled(false);
        }
        if (progress == AbstractOpenShiftWizardPage.Direction.BACKWARDS) {
            return;
        }
        class ImageValidatorJob
        extends Job {
            public ImageValidatorJob(String name) {
                super(name);
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (DeployImagePage.this.model.initializeContainerInfo()) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        }
        ImageValidatorJob imageValidator = new ImageValidatorJob("Looking-up the selected Docker image...");
        try {
            IStatus validatorJobStatus = WizardUtils.runInWizard((Job)imageValidator, (IWizardContainer)this.getContainer(), (DataBindingContext)this.getDataBindingContext());
            if (!validatorJobStatus.isOK()) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)NLS.bind((String)"No Docker image named {0} could be found.", (Object)this.model.getImageName()));
                event.doit = false;
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            String message = NLS.bind((String)"Failed to look-up metadata for a Docker image named {0}.", (Object)this.model.getImageName());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            OpenShiftUIActivator.getDefault().getLogger().logError(message, (Throwable)e);
        }
    }

    protected void onPageWillGetActivated(AbstractOpenShiftWizardPage.Direction progress, PageChangingEvent event, DataBindingContext dbc) {
        if (this.imageNameProposalAdapter != null) {
            this.imageNameProposalAdapter.setEnabled(true);
        }
    }

    protected void onPageActivated(DataBindingContext dbc) {
        this.loadResources(dbc);
        UIUtils.ensureGTK3CombosAreCorrectSize((Composite)((Composite)this.getControl()));
    }

    private void loadResources(DataBindingContext dbc) {
        AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob("Loading projects..."){

            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    DeployImagePage.this.model.loadResources();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    return new Status(4, "org.jboss.tools.openshift.ui", NLS.bind((String)"Unable to load the OpenShift projects from connection {0}.", (Object)DeployImagePage.this.model.getConnection()), (Throwable)e);
                }
            }
        };
        try {
            WizardUtils.runInWizard((Job)job, (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(4).margins(10, 10).applyTo(parent);
        this.createOpenShiftConnectionControl(parent, dbc);
        this.createProjectControl(parent, dbc);
        this.createSeparator(parent);
        if (!this.model.originatedFromDockerExplorer()) {
            this.createDockerConnectionControl(parent, dbc);
        } else {
            this.createDockerConnectionInfoControl(parent, dbc);
        }
        this.createImageNameControls(parent, dbc);
        new ResourceNameControl(){

            @Override
            protected void layoutText(Text resourceNameText) {
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)resourceNameText);
            }
        }.doCreateControl(parent, dbc, this.model);
        this.createSeparator(parent);
        this.createPushToRegistrySettings(parent, dbc);
    }

    private void createSeparator(Composite parent) {
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(4, 1).applyTo((Control)new Label(parent, 258));
    }

    private SelectionAdapter onBrowseImage() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeployImagePage.this.model.getDockerConnection() == null) {
                    MessageDialog.openError((Shell)DeployImagePage.this.getShell(), (String)"A Docker connection must be selected", (String)DeployImagePage.MISSING_DOCKER_CONNECTION_MSG);
                    return;
                }
                ListDockerImagesWizard wizard = new ListDockerImagesWizard(DeployImagePage.this.model.getDockerConnection(), DeployImagePage.this.model.getImageName());
                OkCancelButtonWizardDialog wizardDialog = new OkCancelButtonWizardDialog(DeployImagePage.this.getShell(), (IWizard)wizard);
                wizardDialog.setPageSize(500, 400);
                if (wizardDialog.open() == 0) {
                    DeployImagePage.this.model.setImageName(wizard.getSelectedImageName());
                }
            }
        };
    }

    private SelectionAdapter onSearchImage(final Text txtImage) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeployImagePage.this.model.getDockerConnection() == null) {
                    MessageDialog.openError((Shell)DeployImagePage.this.getShell(), (String)"A Docker connection must be selected", (String)DeployImagePage.MISSING_DOCKER_CONNECTION_MSG);
                    return;
                }
                ImageSearch wizard = new ImageSearch(DeployImagePage.this.model.getDockerConnection(), txtImage.getText(), (IRegistry)new RegistryInfo("https://index.docker.io", true));
                if (new OkCancelButtonWizardDialog(DeployImagePage.this.getShell(), (IWizard)wizard).open() == 0) {
                    DeployImagePage.this.model.setImageName(wizard.getSelectedImage(), true);
                }
            }
        };
    }

    private void createDockerConnectionControl(Composite parent, DataBindingContext dbc) {
        this.createDockerConnectionLabel(parent);
        ComboViewer connectionViewer = new ComboViewer(parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo(connectionViewer.getControl());
        connectionViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        connectionViewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemLabelProvider(){

            @Override
            public String getText(Object element) {
                return element instanceof IDockerConnection ? DeployImagePage.this.dockerConnectionToString((IDockerConnection)element) : "";
            }
        });
        connectionViewer.setInput((Object)BeanProperties.list((String)"dockerConnections").observe((Object)this.model));
        IObservableValue dockerConnectionObservable = BeanProperties.value((String)"dockerConnection").observe((Object)this.model);
        DockerConnectionStatusProvider validator = new DockerConnectionStatusProvider(dockerConnectionObservable);
        IViewerObservableValue selectedConnectionObservable = ViewerProperties.singleSelection().observe((Viewer)connectionViewer);
        Binding selectedConnectionBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedConnectionObservable).converting((IConverter)new ObservableTreeItem2ModelConverter(IDockerConnection.class))).validatingAfterConvert((IValidator)validator)).to(BeanProperties.value((String)"dockerConnection").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedConnectionBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button newDockerConnectionButton = new Button(parent, 8);
        newDockerConnectionButton.setText("New...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)newDockerConnectionButton);
        UIUtils.setDefaultButtonWidth((Button)newDockerConnectionButton);
        newDockerConnectionButton.addSelectionListener((SelectionListener)this.onNewDockerConnectionClicked());
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
    }

    private String dockerConnectionToString(IDockerConnection conn) {
        return NLS.bind((String)"{0} ({1})", (Object)conn.getName(), (Object)conn.getUri());
    }

    private Label createDockerConnectionLabel(Composite parent) {
        Label lblConnection = new Label(parent, 0);
        lblConnection.setText("Docker Connection: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblConnection);
        return lblConnection;
    }

    private void createDockerConnectionInfoControl(Composite parent, DataBindingContext dbc) {
        Label lblConnection = this.createDockerConnectionLabel(parent);
        Text connectionText = new Text(parent, 524296);
        connectionText.setBackground(lblConnection.getBackground());
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)connectionText);
        ISWTObservableValue connnectionTextObservable = WidgetProperties.text((int)0).observe((Widget)connectionText);
        IObservableValue connnectionObservable = BeanProperties.value((String)"dockerConnection").observe((Object)this.model);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)connnectionTextObservable).notUpdatingParticipant()).to(connnectionObservable).converting((IConverter)new ObjectToStringConverter(IDockerConnection.class){
            ConnectionColumLabelProvider labelProvider;
            {
                this.labelProvider = new ConnectionColumLabelProvider();
            }

            public Object convert(Object source) {
                return source instanceof IDockerConnection ? DeployImagePage.this.dockerConnectionToString((IDockerConnection)source) : "";
            }
        })).in(dbc);
    }

    private void createOpenShiftConnectionControl(Composite parent, DataBindingContext dbc) {
        Label lblConnection = new Label(parent, 0);
        lblConnection.setText("OpenShift Connection: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblConnection);
        Text connectionText = new Text(parent, 524296);
        connectionText.setBackground(lblConnection.getBackground());
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)connectionText);
        ISWTObservableValue connnectionTextObservable = WidgetProperties.text((int)0).observe((Widget)connectionText);
        IObservableValue connnectionObservable = BeanProperties.value((String)"connection").observe((Object)this.model);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)connnectionTextObservable).notUpdatingParticipant()).to(connnectionObservable).converting((IConverter)new ObjectToStringConverter(Connection.class){
            ConnectionColumLabelProvider labelProvider;
            {
                this.labelProvider = new ConnectionColumLabelProvider();
            }

            public Object convert(Object source) {
                return source == null ? "" : this.labelProvider.getText(source);
            }
        })).in(dbc);
    }

    private void createProjectControl(Composite parent, DataBindingContext dbc) {
        Label lblProject = new Label(parent, 0);
        lblProject.setText("OpenShift Project: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblProject);
        ComboViewer cmboProject = new ComboViewer(parent);
        GridDataFactory.fillDefaults().span(2, 1).applyTo(cmboProject.getControl());
        OpenShiftExplorerLabelProvider labelProvider = new OpenShiftExplorerLabelProvider();
        cmboProject.setContentProvider((IContentProvider)new ObservableListContentProvider());
        cmboProject.setLabelProvider((IBaseLabelProvider)labelProvider);
        cmboProject.setInput((Object)BeanProperties.list((String)"projects").observe((Object)this.model));
        ProjectViewerComparator comparator = new ProjectViewerComparator((ILabelProvider)labelProvider);
        cmboProject.setComparator((ViewerComparator)comparator);
        this.model.setProjectsComparator(comparator.asProjectComparator());
        IObservableValue projectObservable = BeanProperties.value((String)"project").observe((Object)this.model);
        ProjectStatusProvider validator = new ProjectStatusProvider(projectObservable);
        IViewerObservableValue selectedProjectObservable = ViewerProperties.singleSelection().observe((Viewer)cmboProject);
        Binding selectedProjectBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedProjectObservable).converting((IConverter)new ObservableTreeItem2ModelConverter(IProject.class))).validatingAfterConvert((IValidator)validator)).to(projectObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedProjectBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button newProjectButton = new Button(parent, 8);
        newProjectButton.setText("New...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)newProjectButton);
        UIUtils.setDefaultButtonWidth((Button)newProjectButton);
        newProjectButton.addSelectionListener((SelectionListener)this.onNewProjectClicked());
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        cmboProject.getControl().forceFocus();
    }

    private void createImageNameControls(Composite parent, DataBindingContext dbc) {
        Label imageNameLabel = new Label(parent, 0);
        imageNameLabel.setText("Image Name: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)imageNameLabel);
        Text imageNameText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)imageNameText);
        ISWTObservableValue imageNameTextObservable = WidgetProperties.text((int)24).observeDelayed(500, (Widget)imageNameText);
        IObservableValue imageNameObservable = BeanProperties.value((String)"imageName").observe((Object)this.model);
        Binding imageBinding = ((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)imageNameTextObservable).converting((IConverter)new TrimmingStringConverter())).validatingAfterConvert((IValidator)new DockerImageValidator())).to(imageNameObservable).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)imageBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        this.imageNameProposalAdapter = new ContentProposalAdapter((Control)imageNameText, (IControlContentAdapter)new TextContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                Text imageNameText = (Text)control;
                Point selection = imageNameText.getSelection();
                imageNameText.setText(text);
                selection.y = selection.x = text.length();
                imageNameText.setSelection(selection);
            }
        }, this.getImageNameContentProposalProvider(imageNameText), null, null);
        Button btnDockerBrowse = new Button(parent, 0);
        btnDockerBrowse.setText("Browse...");
        btnDockerBrowse.setToolTipText("Look-up an image by browsing the Docker daemon");
        btnDockerBrowse.addSelectionListener((SelectionListener)this.onBrowseImage());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)btnDockerBrowse);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnDockerBrowse)).notUpdatingParticipant()).to(BeanProperties.value((String)"dockerConnection").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Button btnDockerSearch = new Button(parent, 0);
        btnDockerSearch.setText("Search...");
        btnDockerSearch.setToolTipText("Search an image on the Docker registry");
        btnDockerSearch.addSelectionListener((SelectionListener)this.onSearchImage(imageNameText));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)btnDockerSearch);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnDockerSearch)).notUpdatingParticipant()).to(BeanProperties.value((String)"dockerConnection").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
    }

    private void createPushToRegistrySettings(Composite parent, DataBindingContext dbc) {
        Button pushImageToRegistryButton = new Button(parent, 32);
        pushImageToRegistryButton.setText("Push Image to Registry");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(4, 1).applyTo((Control)pushImageToRegistryButton);
        IObservableValue pushImageToRegistryButtonObservable = BeanProperties.value((String)"pushImageToRegistry").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)pushImageToRegistryButton)).to(pushImageToRegistryButtonObservable).in(dbc);
        Label registryLocationLabel = new Label(parent, 0);
        registryLocationLabel.setText("Image Registry URL:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(30, 0).applyTo((Control)registryLocationLabel);
        Text registryLocationText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)registryLocationText);
        IObservableValue registryLocationObservable = BeanProperties.value((String)"targetRegistryLocation").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)registryLocationText)).to(registryLocationObservable).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)registryLocationText)).to(pushImageToRegistryButtonObservable).in(dbc);
        Label registryUsernameLabel = new Label(parent, 0);
        registryUsernameLabel.setText("Username:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(30, 0).applyTo((Control)registryUsernameLabel);
        Text registryUsernameText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)registryUsernameText);
        IObservableValue registryUsernameObservable = BeanProperties.value((String)"targetRegistryUsername").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)registryUsernameText)).to(registryUsernameObservable).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)registryUsernameText)).to(pushImageToRegistryButtonObservable).in(dbc);
        Label registryPasswordLabel = new Label(parent, 0);
        registryPasswordLabel.setText("Password:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(30, 0).applyTo((Control)registryPasswordLabel);
        Text registryPasswordText = new Text(parent, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)registryPasswordText);
        IObservableValue registryPasswordObservable = BeanProperties.value((String)"targetRegistryPassword").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)registryPasswordText)).to(registryPasswordObservable).in(dbc);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)registryPasswordText)).to(pushImageToRegistryButtonObservable).in(dbc);
        PushImageToRegistryStatusProvider validator = new PushImageToRegistryStatusProvider((IObservableValue<Boolean>)pushImageToRegistryButtonObservable, (IObservableValue<String>)registryLocationObservable, (IObservableValue<String>)registryUsernameObservable, (IObservableValue<String>)registryPasswordObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
    }

    private IContentProposalProvider getImageNameContentProposalProvider(Text imageNameText) {
        return new IContentProposalProvider(){

            public IContentProposal[] getProposals(String input, int position) {
                return (IContentProposal[])DeployImagePage.this.model.getImageNames().stream().filter(name -> name.contains(input)).map(n2 -> new ContentProposal(n2, n2, null, position)).toArray(IContentProposal[]::new);
            }
        };
    }

    private SelectionAdapter onNewProjectClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WizardUtils.runInWizard((Job)new UIJob("Opening projects wizard..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            IProject selectedProject;
                            NewProjectWizard newProjectWizard = new NewProjectWizard((Connection)DeployImagePage.this.model.getConnection(), DeployImagePage.this.model.getProjects());
                            int result = new OkCancelButtonWizardDialog(DeployImagePage.this.getShell(), (IWizard)newProjectWizard).open();
                            if (newProjectWizard.getProject() != null) {
                                DeployImagePage.this.model.addProject(newProjectWizard.getProject());
                            }
                            if (result == 0 && (selectedProject = newProjectWizard.getProject()) != null) {
                                DeployImagePage.this.model.setProject(selectedProject);
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)DeployImagePage.this.getContainer(), (DataBindingContext)DeployImagePage.this.getDataBindingContext());
                }
                catch (InterruptedException | InvocationTargetException exception) {}
            }
        };
    }

    private SelectionAdapter onNewDockerConnectionClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WizardUtils.runInWizard((Job)new UIUpdatingJob("Opening new Docker connection wizard..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            return Status.OK_STATUS;
                        }

                        protected IStatus updateUI(IProgressMonitor monitor) {
                            IDockerConnection dockerConnection;
                            NewDockerConnection newDockerConnectionWizard = new NewDockerConnection();
                            int result = new OkCancelButtonWizardDialog(DeployImagePage.this.getShell(), (IWizard)newDockerConnectionWizard).open();
                            if (result == 0 && (dockerConnection = newDockerConnectionWizard.getDockerConnection()) != null) {
                                DeployImagePage.this.model.setDockerConnection(dockerConnection);
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)DeployImagePage.this.getContainer(), (DataBindingContext)DeployImagePage.this.getDatabindingContext());
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)ex);
                }
            }
        };
    }

    class DockerConnectionStatusProvider
    extends MultiValidator
    implements IValidator {
        IObservableValue dockerConnectionObservable;

        DockerConnectionStatusProvider(IObservableValue dockerConnectionObservable) {
            this.dockerConnectionObservable = dockerConnectionObservable;
        }

        public IStatus validate(Object value) {
            if (value instanceof IDockerConnection) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.cancel((String)DeployImagePage.MISSING_DOCKER_CONNECTION_MSG);
        }

        protected IStatus validate() {
            return this.validate(this.dockerConnectionObservable.getValue());
        }
    }

    class ProjectStatusProvider
    extends MultiValidator
    implements IValidator {
        IObservableValue projectObservable;

        ProjectStatusProvider(IObservableValue projectObservable) {
            this.projectObservable = projectObservable;
        }

        public IStatus validate(Object value) {
            if (value instanceof IProject) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.cancel((String)"Please choose an OpenShift project.");
        }

        protected IStatus validate() {
            return this.validate(this.projectObservable.getValue());
        }
    }

    class PushImageToRegistryStatusProvider
    extends MultiValidator {
        private final IObservableValue<Boolean> pushImageToRegistryObservable;
        private final IObservableValue<String> targetRegistryLocationObservable;
        private final IObservableValue<String> targetRegistryUsernameObservable;
        private final IObservableValue<String> targetRegistryPasswordObservable;

        PushImageToRegistryStatusProvider(IObservableValue<Boolean> pushImageToRegistryObservable, IObservableValue<String> targetRegistryLocationObservable, IObservableValue<String> targetRegistryUsernameObservable, IObservableValue<String> targetRegistryPasswordObservable) {
            this.pushImageToRegistryObservable = pushImageToRegistryObservable;
            this.targetRegistryLocationObservable = targetRegistryLocationObservable;
            this.targetRegistryUsernameObservable = targetRegistryUsernameObservable;
            this.targetRegistryPasswordObservable = targetRegistryPasswordObservable;
        }

        protected IStatus validate() {
            boolean pushImageToRegistry = (Boolean)this.pushImageToRegistryObservable.getValue();
            String targetRegistryLocation = (String)this.targetRegistryLocationObservable.getValue();
            String targetRegistryUsername = (String)this.targetRegistryUsernameObservable.getValue();
            String targetRegistryPassword = (String)this.targetRegistryPasswordObservable.getValue();
            if (pushImageToRegistry) {
                if (targetRegistryLocation == null || targetRegistryLocation.isEmpty()) {
                    return ValidationStatus.error((String)"Please specify location of the Docker registry to push the image");
                }
                if (!UrlUtils.hasScheme((String)targetRegistryLocation)) {
                    return ValidationStatus.error((String)"Please provide a valid image registry (HTTP/S) URL.");
                }
                if (targetRegistryUsername == null || targetRegistryUsername.isEmpty()) {
                    return ValidationStatus.info((String)"The username to authenticate to the target registry is missing. Authentication may fail.");
                }
                if (targetRegistryPassword == null || targetRegistryPassword.isEmpty()) {
                    return ValidationStatus.info((String)"The password to authenticate to the target registry is missing. Authentication may fail.");
                }
            }
            return Status.OK_STATUS;
        }
    }
}

