/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IProject;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.docker.core.IRepositoryTag;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.UsageStats;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPage;
import org.jboss.tools.openshift.internal.common.ui.utils.OpenShiftUIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAware;
import org.jboss.tools.openshift.internal.core.docker.PushImageToRegistryJob;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryDialog;
import org.jboss.tools.openshift.internal.ui.job.DeployImageJob;
import org.jboss.tools.openshift.internal.ui.job.RefreshResourcesJob;
import org.jboss.tools.openshift.internal.ui.wizard.common.IResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceLabelsPage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeployImagePage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeployImageWizardModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeploymentConfigPage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImagePageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImageParameters;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeploymentConfigPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IServiceAndRoutingPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicesAndRoutingPage;

public class DeployImageWizard
extends AbstractOpenShiftWizard<IDeployImageParameters> {
    private static final String TITLE = "Deploy Image to OpenShift";

    public DeployImageWizard(IDockerConnection dockerConnection, IDockerImage image, Connection connection, IProject project, boolean isAuthorized) {
        super(TITLE, (Object)new DeployImageWizardModel());
        DeployImageWizardModel model = (DeployImageWizardModel)this.getModel();
        if (dockerConnection != null || image != null) {
            model.setDockerConnection(image != null ? image.getConnection() : dockerConnection);
            if (image != null) {
                model.setOriginatedFromDockerExplorer(true);
                model.setImageName(this.getImageNameWithTag(image));
            }
        }
        model.setStartedWithActiveConnection(isAuthorized);
        model.setConnection(connection);
        model.setProject(project);
        this.setNeedsProgressMonitor(true);
    }

    private String getImageNameWithTag(IDockerImage image) {
        String imageName = image.repo();
        if (!image.tags().isEmpty()) {
            TreeSet tags = new TreeSet(image.tags());
            imageName = String.valueOf(imageName) + ":" + (String)tags.first();
        }
        return imageName;
    }

    public void addPages() {
        if (((IDeployImageParameters)this.getModel()).originatedFromDockerExplorer() || !((DeployImageWizardModel)this.getModel()).isStartedWithActiveConnection()) {
            this.addPage((IWizardPage)new ConnectionWizardPage((IWizard)this, (IConnectionAware)this.getModel(), Connection.class));
        }
        this.addPage((IWizardPage)new DeployImagePage((IWizard)this, (IDeployImagePageModel)this.getModel()));
        this.addPage((IWizardPage)new DeploymentConfigPage((IWizard)this, (IDeploymentConfigPageModel)this.getModel()));
        this.addPage((IWizardPage)new ServicesAndRoutingPage((IWizard)this, (IServiceAndRoutingPageModel)this.getModel()));
        this.addPage((IWizardPage)new ResourceLabelsPage((IWizard)this, (IResourceLabelsPageModel)this.getModel()));
    }

    public IWizardPage getStartingPage() {
        if (((DeployImageWizardModel)this.getModel()).isStartedWithActiveConnection()) {
            return this.getPage(DeployImagePage.DEPLOY_IMAGE_PAGE_NAME);
        }
        return super.getStartingPage();
    }

    public boolean performFinish() {
        Job job = this.getJobChain((IDeployImageParameters)this.getModel(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                UsageStats.getInstance().newV3Application(((Connection)((IDeployImageParameters)DeployImageWizard.this.getModel()).getConnection()).getHost(), DeployImageWizard.isFailed(status));
                super.done(event);
            }
        });
        job.schedule();
        return true;
    }

    private Job getJobChain(IDeployImageParameters model, Shell shell) {
        DeployImageJob deployJob = DeployImageWizard.getDeployImageJob((IDeployImageParameters)this.getModel(), this.getShell());
        boolean pushImageToRegistry = model.isPushImageToRegistry();
        if (pushImageToRegistry) {
            PushImageToRegistryJob pushImageToRegistryJob = DeployImageWizard.getPushImageToRegistryJob(model);
            return new JobChainBuilder((Job)pushImageToRegistryJob).runWhenSuccessfullyDone((Job)deployJob).runWhenSuccessfullyDone((Job)new RefreshResourcesJob(deployJob, true)).build();
        }
        return new JobChainBuilder((Job)deployJob).runWhenSuccessfullyDone((Job)new RefreshResourcesJob(deployJob, true)).build();
    }

    private static DeployImageJob getDeployImageJob(IDeployImageParameters model, final Shell shell) {
        final DeployImageJob deployJob = new DeployImageJob(model);
        deployJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if ((JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status)) && !deployJob.getResources().isEmpty()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            new ResourceSummaryDialog(shell, deployJob.getResources(), DeployImageWizard.TITLE, deployJob.getSummaryMessage()).open();
                        }
                    });
                    OpenShiftUIUtils.showOpenShiftExplorer();
                }
            }
        });
        return deployJob;
    }

    private static PushImageToRegistryJob getPushImageToRegistryJob(final IDeployImageParameters model) {
        IDockerConnection dockerConnection = model.getDockerConnection();
        String imageName = model.getImageName();
        String deployProjectName = model.getProject().getName();
        IRegistryAccount registryAccount = new IRegistryAccount(){

            public String getServerAddress() {
                return model.getTargetRegistryLocation();
            }

            public String getUsername() {
                return model.getTargetRegistryUsername();
            }

            public char[] getPassword() {
                return model.getTargetRegistryPassword().toCharArray();
            }

            public String getEmail() {
                return null;
            }

            public List<IRepositoryTag> getTags(String arg0) throws DockerException {
                return null;
            }

            public boolean isVersion2() {
                return false;
            }

            public List<IDockerImageSearchResult> getImages(String arg0) throws DockerException {
                return null;
            }
        };
        return new PushImageToRegistryJob(dockerConnection, registryAccount, deployProjectName, imageName);
    }

    public static boolean isFailed(IStatus status) {
        return JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status);
    }

    public void dispose() {
        super.dispose();
    }
}

