/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IServicePort;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.core.docker.DockerConfigMetaData;
import org.jboss.tools.openshift.internal.core.docker.DockerImageUtils;
import org.jboss.tools.openshift.internal.core.docker.IDockerImageMetadata;
import org.jboss.tools.openshift.internal.core.models.PortSpecAdapter;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariable;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariablesPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DockerImage2OpenshiftResourceConverter;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImageParameters;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicePortAdapter;

public class DeployImageWizardModel
extends ResourceLabelsPageModel
implements IDeployImageParameters,
IDockerConnectionManagerListener,
PropertyChangeListener {
    private static final int DEFAULT_REPLICA_COUNT = 1;
    private Connection connection;
    private IProject project;
    private List<IProject> projects = new ArrayList<IProject>();
    private String resourceName;
    private String imageName;
    private EnvironmentVariablesPageModel envModel = new EnvironmentVariablesPageModel();
    private List<String> volumes = Collections.emptyList();
    private String selectedVolume;
    private List<IPort> portSpecs = Collections.emptyList();
    private int replicas;
    private boolean addRoute = true;
    private String routeHostname;
    List<IServicePort> servicePorts = new ArrayList<IServicePort>();
    IServicePort selectedServicePort = null;
    private IDockerConnection dockerConnection;
    private ArrayList<IServicePort> imagePorts;
    private boolean originatedFromDockerExplorer;
    private boolean isStartedWithActiveConnection = false;
    private IDockerImageMetadata imageMeta;
    private boolean pushImageToRegistry = false;
    private String targetRegistryLocation;
    private String targetRegistryUsername;
    private String targetRegistryPassword;
    private IServicePort routingPort;
    private static final DockerImage2OpenshiftResourceConverter dockerImage2OpenshiftResourceConverter = new DockerImage2OpenshiftResourceConverter();
    private final List<String> imageNames = new ArrayList<String>();
    private List<IDockerConnection> dockerConnections = Arrays.asList(DockerConnectionManager.getInstance().getConnections());
    private Comparator<IProject> projectsComparator;
    protected boolean resourcesLoaded = false;

    public DeployImageWizardModel() {
        this.envModel.addPropertyChangeListener("environmentVariables", this);
        this.envModel.addPropertyChangeListener("selectedEnvironmentVariable", this);
        DockerConnectionManager.getInstance().addConnectionManagerListener((IDockerConnectionManagerListener)this);
    }

    @Override
    public void dispose() {
        super.dispose();
        DockerConnectionManager.getInstance().removeConnectionManagerListener((IDockerConnectionManagerListener)this);
        this.envModel.dispose();
        this.connection = null;
        this.project = null;
        this.dockerConnection = null;
        this.projects.clear();
        this.volumes.clear();
        this.portSpecs.clear();
        if (this.imagePorts != null) {
            this.imagePorts.clear();
            this.imagePorts = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    @Override
    public void setOriginatedFromDockerExplorer(boolean orig) {
        this.originatedFromDockerExplorer = orig;
    }

    @Override
    public boolean originatedFromDockerExplorer() {
        return this.originatedFromDockerExplorer;
    }

    @Override
    public boolean isStartedWithActiveConnection() {
        return this.isStartedWithActiveConnection;
    }

    public void setStartedWithActiveConnection(boolean active) {
        this.isStartedWithActiveConnection = active;
    }

    @Override
    public List<IDockerConnection> getDockerConnections() {
        return this.dockerConnections;
    }

    @Override
    public IDockerConnection getDockerConnection() {
        List<IDockerConnection> all;
        if (this.dockerConnection == null && (all = this.getDockerConnections()).size() == 1) {
            this.setDockerConnection(all.get(0));
        }
        return this.dockerConnection;
    }

    @Override
    public Collection<Connection> getConnections() {
        return ConnectionsRegistrySingleton.getInstance().getAll(Connection.class);
    }

    public Connection getConnection() {
        Collection<Connection> connections;
        if (this.connection == null && (connections = this.getConnections()).size() == 1) {
            this.setConnection(connections.iterator().next());
        }
        return this.connection;
    }

    private void initImageRegistry(Connection connection) {
        if (connection == null) {
            return;
        }
        this.setTargetRegistryLocation((String)connection.getExtendedProperties().get("org.jbosstools.openshift.core.connection.ext.registry.url"));
        this.setTargetRegistryUsername(connection.getUsername());
        this.setTargetRegistryPassword(connection.getToken());
    }

    public void setConnection(Connection connection) {
        Connection oldConnection = this.connection;
        this.connection = connection;
        this.firePropertyChange("connection", this.connection, this.connection);
        this.initImageRegistry(connection);
        this.resourcesLoaded = this.resourcesLoaded && ObjectUtils.equals((Object)oldConnection, (Object)connection);
    }

    @Override
    public void loadResources() {
        if (this.resourcesLoaded) {
            return;
        }
        List projects = this.connection.getResources("Project");
        this.setProjects(projects);
        this.setProjectOrDefault(this.project);
        this.resourcesLoaded = true;
    }

    protected void setProjects(List<IProject> projects) {
        if (projects == null) {
            projects = Collections.emptyList();
        }
        this.projects = projects;
        this.firePropertyChange("projects", this.projects, this.projects);
    }

    @Override
    public List<IProject> getProjects() {
        return this.projects;
    }

    @Override
    public void addProject(IProject project) {
        if (project == null) {
            return;
        }
        ArrayList<IProject> newProjects = new ArrayList<IProject>(this.projects);
        newProjects.add(project);
        this.setProjects(newProjects);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
        this.firePropertyChange("project", this.project, this.project);
    }

    protected void setProjectOrDefault(IProject project) {
        if (this.projects == null) {
            return;
        }
        if (project != null && this.projects.contains(project)) {
            this.setProject(project);
        } else if (!this.projects.isEmpty()) {
            project = this.getDefaultProject();
            this.setProject(project);
        }
    }

    private IProject getDefaultProject() {
        IProject project;
        if (this.projectsComparator != null) {
            Collections.sort(this.projects, this.projectsComparator);
            project = this.projects.get(0);
        } else {
            project = this.projects.get(0);
        }
        return project;
    }

    @Override
    public void setProjectsComparator(Comparator<IProject> comparator) {
        this.projectsComparator = comparator;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
        this.firePropertyChange("resourceName", this.resourceName, this.resourceName);
    }

    @Override
    public String getImageName() {
        return this.imageName;
    }

    @Override
    public void setImageName(String imageName) {
        if (StringUtils.isBlank((String)imageName)) {
            return;
        }
        if (this.imageName != null && !this.imageName.equals(imageName) && this.imageMeta != null) {
            this.imageMeta = null;
            this.setEnvironmentVariables(new ArrayList<EnvironmentVariable>());
            this.setPortSpecs(new ArrayList<IPort>());
            this.setVolumes(new ArrayList<String>());
        }
        this.imageName = imageName;
        this.firePropertyChange("imageName", this.imageName, this.imageName);
        DockerImageURI uri = new DockerImageURI(imageName);
        this.setResourceName(dockerImage2OpenshiftResourceConverter.convert(uri));
    }

    @Override
    public void setImageName(String imageName, boolean forceUpdate) {
        if (forceUpdate && this.imageName != null && this.imageName.equals(imageName)) {
            this.imageName = null;
            this.firePropertyChange("imageName", this.imageName, null);
        }
        this.setImageName(imageName);
    }

    @Override
    public boolean isPushImageToRegistry() {
        return this.pushImageToRegistry;
    }

    @Override
    public void setPushImageToRegistry(boolean pushImageToRegistry) {
        this.pushImageToRegistry = pushImageToRegistry;
        this.firePropertyChange("pushImageToRegistry", this.pushImageToRegistry, this.pushImageToRegistry);
    }

    @Override
    public String getTargetRegistryLocation() {
        return this.targetRegistryLocation;
    }

    @Override
    public void setTargetRegistryLocation(String targetRegistryLocation) {
        this.targetRegistryLocation = targetRegistryLocation;
        this.firePropertyChange("targetRegistryLocation", this.targetRegistryLocation, this.targetRegistryLocation);
    }

    @Override
    public String getTargetRegistryUsername() {
        return this.targetRegistryUsername;
    }

    @Override
    public void setTargetRegistryUsername(String targetRegistryUsername) {
        this.targetRegistryUsername = targetRegistryUsername;
        this.firePropertyChange("targetRegistryUsername", this.targetRegistryUsername, this.targetRegistryUsername);
    }

    @Override
    public String getTargetRegistryPassword() {
        return this.targetRegistryPassword;
    }

    @Override
    public void setTargetRegistryPassword(String targetRegistryPassword) {
        this.targetRegistryPassword = targetRegistryPassword;
        this.firePropertyChange("targetRegistryPassword", this.targetRegistryPassword, this.targetRegistryPassword);
    }

    @Override
    public boolean initializeContainerInfo() {
        this.imageMeta = this.lookupImageMetadata();
        if (this.imageMeta == null) {
            return false;
        }
        this.initEnvVariables();
        this.initExposedPorts();
        this.initVolumes();
        this.setReplicas(1);
        return true;
    }

    private void initExposedPorts() {
        List<Object> portSpecs = Collections.emptyList();
        if (this.imageMeta != null && !CollectionUtils.isEmpty((Collection)this.imageMeta.exposedPorts())) {
            portSpecs = this.imageMeta.exposedPorts().stream().map(spec -> new PortSpecAdapter(spec)).collect(Collectors.toList());
        }
        this.setPortSpecs(portSpecs);
    }

    private void initEnvVariables() {
        List<EnvironmentVariable> envVars = Collections.emptyList();
        if (this.imageMeta != null && !CollectionUtils.isEmpty((Collection)this.imageMeta.env())) {
            envVars = this.imageMeta.env().stream().filter(env -> env != null && env.indexOf(61) != -1).map(env -> env.split("=")).map(splittedEnv -> new EnvironmentVariable(splittedEnv[0], ((String[])splittedEnv).length > 1 ? splittedEnv[1] : "")).collect(Collectors.toList());
        }
        this.setEnvironmentVariables(envVars);
    }

    private void initVolumes() {
        List<String> volumes = Collections.emptyList();
        if (this.imageMeta != null && !CollectionUtils.isEmpty((Collection)this.imageMeta.volumes())) {
            volumes = new ArrayList<String>(this.imageMeta.volumes());
        }
        this.setVolumes(volumes);
    }

    @Override
    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.envModel.getEnvironmentVariables();
    }

    @Override
    public boolean isEnvironmentVariableModified(EnvironmentVariable envVar) {
        return this.envModel.isEnvironmentVariableModified(envVar);
    }

    @Override
    public void setEnvironmentVariables(List<EnvironmentVariable> envVars) {
        this.envModel.setEnvironmentVariables(envVars);
    }

    @Override
    public EnvironmentVariable getEnvironmentVariable(String key) {
        return this.envModel.getEnvironmentVariable(key);
    }

    @Override
    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
        this.firePropertyChange("volumes", this.volumes, this.volumes);
    }

    @Override
    public List<String> getVolumes() {
        return this.volumes;
    }

    private void setPortSpecs(List<IPort> portSpecs) {
        this.portSpecs = portSpecs;
        this.firePropertyChange("portSpecs", this.portSpecs, this.portSpecs);
        this.setServicePortsFromPorts(portSpecs);
    }

    private void setServicePortsFromPorts(List<IPort> portSpecs) {
        this.imagePorts = new ArrayList(portSpecs.size());
        ArrayList<IServicePort> servicePorts = new ArrayList<IServicePort>(portSpecs.size());
        for (IPort port : portSpecs) {
            servicePorts.add(new ServicePortAdapter(port));
            this.imagePorts.add(new ServicePortAdapter(port));
        }
        this.setServicePorts(servicePorts);
    }

    private void setServicePorts(List<IServicePort> servicePorts) {
        if (servicePorts.size() > 0) {
            ServicePortAdapter adapterPort = (ServicePortAdapter)servicePorts.get(0);
            adapterPort.setRoutePort(true);
            this.setRoutingPort(adapterPort);
        } else {
            this.setRoutingPort(null);
        }
        this.servicePorts = servicePorts;
        this.firePropertyChange("servicePorts", this.servicePorts, this.servicePorts);
    }

    @Override
    public List<IPort> getPortSpecs() {
        return this.portSpecs;
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public void setReplicas(int replicas) {
        this.replicas = replicas;
        this.firePropertyChange("replicas", this.replicas, this.replicas);
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public Object getContext() {
        return null;
    }

    @Override
    public boolean isAddRoute() {
        return this.addRoute;
    }

    @Override
    public void setAddRoute(boolean addRoute) {
        this.addRoute = addRoute;
        this.firePropertyChange("addRoute", this.addRoute, this.addRoute);
    }

    @Override
    public String getRouteHostname() {
        return this.routeHostname;
    }

    @Override
    public void setRouteHostname(String routeHostname) {
        this.routeHostname = routeHostname;
        this.firePropertyChange("routeHostname", this.routeHostname, this.routeHostname);
    }

    @Override
    public List<IServicePort> getServicePorts() {
        return this.servicePorts;
    }

    @Override
    public void setSelectedEnvironmentVariable(EnvironmentVariable envVar) {
        this.envModel.setSelectedEnvironmentVariable(envVar);
    }

    @Override
    public EnvironmentVariable getSelectedEnvironmentVariable() {
        return this.envModel.getSelectedEnvironmentVariable();
    }

    @Override
    public void removeEnvironmentVariable(EnvironmentVariable envVar) {
        this.envModel.removeEnvironmentVariable(envVar);
    }

    @Override
    public void updateEnvironmentVariable(EnvironmentVariable envVar, String key, String value) {
        this.envModel.updateEnvironmentVariable(envVar, key, value);
    }

    @Override
    public void resetEnvironmentVariable(EnvironmentVariable envVar) {
        this.envModel.resetEnvironmentVariable(envVar);
    }

    @Override
    public void addEnvironmentVariable(String key, String value) {
        this.envModel.addEnvironmentVariable(key, value);
    }

    @Override
    public void addServicePort(IServicePort port) {
        if (this.servicePorts.contains(port)) {
            return;
        }
        ArrayList<IServicePort> old = new ArrayList<IServicePort>(this.servicePorts);
        this.servicePorts.add(port);
        this.firePropertyChange("servicePorts", old, Collections.unmodifiableList(this.servicePorts));
        if (port instanceof ServicePortAdapter && ((ServicePortAdapter)port).isRoutePort()) {
            this.setRoutingPort(port);
        }
    }

    @Override
    public void updateServicePort(IServicePort source, IServicePort target) {
        int pos = this.servicePorts.indexOf(source);
        if (pos > -1) {
            ArrayList<IServicePort> old = new ArrayList<IServicePort>(this.servicePorts);
            this.servicePorts.set(pos, target);
            String p = target.getTargetPort();
            target.setTargetPort("dummy");
            this.fireIndexedPropertyChange("servicePorts", pos, old, Collections.unmodifiableList(this.servicePorts));
            if (((ServicePortAdapter)target).isRoutePort()) {
                this.setRoutingPort(target);
            } else if (((ServicePortAdapter)source).isRoutePort() && !((ServicePortAdapter)target).isRoutePort()) {
                this.setRoutingPort(null);
            }
            target.setTargetPort(p);
        }
    }

    @Override
    public void setSelectedVolume(String volume) {
        this.selectedVolume = volume;
        this.firePropertyChange("selectedVolume", this.selectedVolume, this.selectedVolume);
    }

    @Override
    public String getSelectedVolume() {
        return this.selectedVolume;
    }

    @Override
    public void updateVolume(String volume, String value) {
        LinkedHashSet<String> old = new LinkedHashSet<String>(this.volumes);
        this.volumes.remove(volume);
        this.volumes.add(value);
        this.firePropertyChange("volumes", old, Collections.unmodifiableList(this.volumes));
    }

    @Override
    public void setSelectedServicePort(IServicePort servicePort) {
        this.selectedServicePort = servicePort;
        this.firePropertyChange("selectedServicePort", this.selectedServicePort, this.selectedServicePort);
    }

    @Override
    public IServicePort getSelectedServicePort() {
        return this.selectedServicePort;
    }

    @Override
    public void removeServicePort(IServicePort port) {
        int index = this.servicePorts.indexOf(port);
        if (index > -1) {
            ArrayList<IServicePort> old = new ArrayList<IServicePort>(this.servicePorts);
            this.servicePorts.remove(port);
            this.fireIndexedPropertyChange("servicePorts", index, old, Collections.unmodifiableList(this.servicePorts));
        }
    }

    @Override
    public void setDockerConnection(IDockerConnection dockerConnection) {
        this.dockerConnection = dockerConnection;
        this.firePropertyChange("dockerConnection", this.dockerConnection, this.dockerConnection);
        this.imageNames.clear();
        if (dockerConnection == null) {
            return;
        }
        List images = dockerConnection.getImages();
        if (images != null) {
            this.imageNames.addAll(dockerConnection.getImages().stream().filter(image -> !image.isDangling() && !image.isIntermediateImage()).flatMap(image -> image.repoTags().stream()).sorted().collect(Collectors.toList()));
        }
    }

    protected IDockerImageMetadata lookupImageMetadata() {
        if (StringUtils.isBlank((String)this.imageName)) {
            return null;
        }
        DockerImageURI imageURI = new DockerImageURI(this.imageName);
        String repo = imageURI.getUriWithoutTag();
        String tag = StringUtils.defaultIfBlank((String)imageURI.getTag(), (String)"latest");
        if (this.dockerConnection != null && DockerImageUtils.hasImage((IDockerConnection)this.dockerConnection, (String)repo, (String)tag)) {
            IDockerImageInfo info = this.dockerConnection.getImageInfo(this.imageName);
            if (info == null) {
                return null;
            }
            return new DockerConfigMetaData(info);
        }
        if (this.project != null) {
            return DockerImageUtils.lookupImageMetadata((IProject)this.project, (DockerImageURI)imageURI);
        }
        return null;
    }

    @Override
    public List<String> getImageNames() {
        return this.imageNames;
    }

    @Override
    public void resetServicePorts() {
        List<IServicePort> ports = this.imagePorts.stream().map(sp -> new ServicePortAdapter((IServicePort)sp)).collect(Collectors.toList());
        this.setServicePorts(ports);
    }

    @Override
    public void setRoutingPort(IServicePort port) {
        if (this.routingPort != null) {
            ((ServicePortAdapter)this.routingPort).setRoutePort(false);
        }
        this.routingPort = port;
        this.firePropertyChange("routingPort", this.routingPort, this.routingPort);
    }

    @Override
    public IServicePort getRoutingPort() {
        return this.routingPort;
    }

    @Override
    public Map<String, String> getImageEnvVars() {
        return this.envModel.getImageEnvVars();
    }

    public void changeEvent(IDockerConnection connection, int event) {
        if (event == 0 || event == 1) {
            this.dockerConnections = Arrays.asList(DockerConnectionManager.getInstance().getConnections());
            this.firePropertyChange("dockerConnections", this.dockerConnections, this.dockerConnections);
        }
    }
}

