/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.IServicePort;
import org.jboss.tools.common.databinding.ObservablePojo;

public class ServicePortAdapter
extends ObservablePojo
implements IServicePort {
    public static final String NAME = "name";
    public static final String PORT = "port";
    public static final String TARGET_PORT = "targetPort";
    public static final String ROUTE_PORT = "routePort";
    private String name;
    private int port;
    private String containerPort;
    private String protocol;
    private boolean routePort;

    public ServicePortAdapter(IPort port) {
        this.name = port.getName();
        this.port = port.getContainerPort();
        this.containerPort = String.valueOf(port.getContainerPort());
        this.protocol = port.getProtocol();
    }

    public ServicePortAdapter(ServicePortAdapter port) {
        this((IServicePort)port);
        this.routePort = port.isRoutePort();
    }

    public ServicePortAdapter(IServicePort port) {
        this.name = port.getName();
        this.port = port.getPort();
        this.containerPort = "0".equals(port.getTargetPort()) ? String.valueOf(this.port) : port.getTargetPort();
        this.protocol = port.getProtocol();
    }

    public ServicePortAdapter() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.firePropertyChange(PORT, this.port, this.port);
    }

    public String getTargetPort() {
        return this.containerPort;
    }

    public void setTargetPort(int port) {
        this.containerPort = String.valueOf(port);
        this.firePropertyChange(TARGET_PORT, this.containerPort, this.containerPort);
    }

    public void setTargetPort(String intOrString) {
        this.containerPort = String.valueOf(intOrString);
        this.firePropertyChange(TARGET_PORT, this.containerPort, this.containerPort);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String proto) {
        this.protocol = proto;
        this.firePropertyChange("protocol", this.protocol, this.protocol);
    }

    public boolean isRoutePort() {
        return this.routePort;
    }

    public void setRoutePort(boolean routePort) {
        this.routePort = routePort;
        this.firePropertyChange(ROUTE_PORT, this.routePort, this.routePort);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.port;
        result = 31 * result + (this.containerPort == null ? 0 : this.containerPort.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.routePort ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServicePortAdapter other = (ServicePortAdapter)((Object)obj);
        if (this.port != other.port) {
            return false;
        }
        if (this.containerPort == null ? other.containerPort != null : !this.containerPort.equals(other.containerPort)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.protocol == null) {
            if (other.protocol != null) {
                return false;
            }
        } else {
            if (!this.protocol.equals(other.protocol)) {
                return false;
            }
            if (this.routePort != other.routePort) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "ServicePortAdapter [name=" + this.name + ", port=" + this.port + ", containerPort=" + this.containerPort + ", protocol=" + this.protocol + ", routePort=" + this.routePort + "]";
    }
}

