/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IServicePort;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.PodPortValidator;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicePortAdapter;

public class ServicePortDialog
extends AbstractOpenShiftWizardPage {
    static final String UNIQUE_ERROR = "The {0} port number must be unique among all the other ports exposed by this OpenShift service.";
    static final String PROPERTY_SERVICE_PORT = "port";
    static final String PROPERTY_POD_PORT = "targetPort";
    private final ServicePortAdapter model;
    private final List<IServicePort> ports;

    public ServicePortDialog(ServicePortAdapter model, String message, List<IServicePort> ports) {
        super("Configure Service Ports", message, "", null);
        this.model = model;
        this.ports = ports;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(1, 1).applyTo(parent);
        Composite dialogArea = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)dialogArea);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(dialogArea);
        Label servicePortLabel = new Label(dialogArea, 0);
        servicePortLabel.setText("Service port:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)servicePortLabel);
        Spinner servicePortSpinner = new Spinner(dialogArea, 2048);
        servicePortSpinner.setMinimum(1);
        servicePortSpinner.setMaximum(65535);
        servicePortSpinner.setToolTipText("The port exposed by the service that will route to the pod.");
        servicePortSpinner.addModifyListener(e -> {
            Spinner source = (Spinner)e.getSource();
            if (!String.valueOf(source.getSelection()).equals(source.getText())) {
                source.setSelection(source.getSelection());
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)servicePortSpinner);
        Binding servicePortBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)servicePortSpinner)).validatingAfterConvert((IValidator)new ServicePortValidator(this.model.getPort(), this.ports))).to(BeanProperties.value((String)PROPERTY_SERVICE_PORT).observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)servicePortBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label podPortLabel = new Label(dialogArea, 0);
        podPortLabel.setText("Pod port:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)podPortLabel);
        Text podPortText = new Text(dialogArea, 2048);
        podPortText.setToolTipText("The port exposed by the pod which will accept traffic.\nIt must be an integer or the name of a port in the backend Pods.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)podPortText);
        Binding podPortBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)podPortText)).validatingAfterConvert((IValidator)new PodPortValidator(this.model.getTargetPort(), this.ports))).to(BeanProperties.value((String)PROPERTY_POD_PORT).observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)podPortBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Button routePortButton = new Button(dialogArea, 32);
        routePortButton.setText("Used by route");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)routePortButton);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)routePortButton)).to(BeanProperties.value((String)"routePort").observe((Object)this.model)).in(dbc);
    }

    public int open() {
        ServicePortDialog page = this;
        Wizard wizard = new Wizard((IWizardPage)page){
            private final /* synthetic */ IWizardPage val$page;
            {
                this.val$page = iWizardPage;
            }

            public boolean performFinish() {
                return true;
            }

            public void addPages() {
                this.addPage(this.val$page);
            }
        };
        wizard.setNeedsProgressMonitor(true);
        wizard.setWindowTitle("Service Ports");
        this.setWizard((IWizard)wizard);
        OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog(this.getShell(), (IWizard)wizard);
        return dialog.open();
    }

    static class ServicePortValidator
    implements IValidator {
        private static final IStatus SERVICE_PORT_ERROR = ValidationStatus.error((String)NLS.bind((String)"The {0} port number must be unique among all the other ports exposed by this OpenShift service.", (Object)"service"));
        private final int servicePort;
        private final List<? extends IServicePort> ports;

        public ServicePortValidator(int servicePort, List<? extends IServicePort> ports) {
            this.servicePort = servicePort;
            this.ports = ports;
        }

        public IStatus validate(Object value) {
            Integer newPort = (Integer)value;
            if (this.servicePort != newPort) {
                for (IServicePort iServicePort : this.ports) {
                    if (newPort.intValue() != iServicePort.getPort()) continue;
                    return SERVICE_PORT_ERROR;
                }
            }
            return ValidationStatus.OK_STATUS;
        }
    }
}

