/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IServicePort;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.DomainValidator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.TableCellMouseAdapter;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimmingStringConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.OpenShiftImages;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIMessages;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IServiceAndRoutingPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicePortAdapter;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicePortDialog;

public class ServicesAndRoutingPage
extends AbstractOpenShiftWizardPage {
    private static final String PAGE_NAME = "Services && Routing Settings Page";
    private static final String PAGE_TITLE = "Services && Routing Settings";
    private static final String PAGE_DESCRIPTION = "";
    private static final int ROUTE_PORT_COLUMN_INDEX = 3;
    private IServiceAndRoutingPageModel model;
    TableViewer portsViewer;

    public ServicesAndRoutingPage(IWizard wizard, IServiceAndRoutingPageModel model) {
        super(PAGE_TITLE, PAGE_DESCRIPTION, PAGE_NAME, wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        this.createExposedPortsControl(parent, dbc);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)new Label(parent, 258));
        Composite routingContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)routingContainer);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo(routingContainer);
        Button btnAddRoute = new Button(routingContainer, 32);
        btnAddRoute.setText("Add Route");
        btnAddRoute.setToolTipText("Adding a route to the service will make the image accessible\noutside of the OpenShift cluster on all the available service ports. \nYou can target a specific port by editing the route later.");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).span(2, 1).applyTo((Control)btnAddRoute);
        final IObservableValue addRouteModelObservable = BeanProperties.value((String)"addRoute").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)btnAddRoute)).to(addRouteModelObservable).in(dbc);
        Label labelRouteHostname = new Label(routingContainer, 0);
        labelRouteHostname.setText("Hostname:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)labelRouteHostname);
        Text textRouteHostname = new Text(routingContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)textRouteHostname);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)textRouteHostname)).to(BeanProperties.value((String)"addRoute").observe((Object)this.model)).in(dbc);
        ISWTObservableValue routeHostnameObservable = WidgetProperties.text((int)24).observe((Widget)textRouteHostname);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)routeHostnameObservable).converting((IConverter)new TrimmingStringConverter())).to(BeanProperties.value((String)"routeHostname").observe((Object)this.model)).in(dbc);
        MultiValidator validator = new MultiValidator((IObservableValue)routeHostnameObservable){
            private final /* synthetic */ IObservableValue val$routeHostnameObservable;
            {
                this.val$routeHostnameObservable = iObservableValue2;
            }

            protected IStatus validate() {
                IStatus status = ValidationStatus.ok();
                boolean isAddRoute = (Boolean)addRouteModelObservable.getValue();
                String hostName = (String)this.val$routeHostnameObservable.getValue();
                IObservableList portsObservable = BeanProperties.list((String)"servicePorts").observe((Object)ServicesAndRoutingPage.this.model);
                IServicePort routingPort = (IServicePort)BeanProperties.value((String)"routingPort").observe((Object)ServicesAndRoutingPage.this.model).getValue();
                if (isAddRoute) {
                    if (StringUtils.isBlank((String)hostName)) {
                        status = ValidationStatus.info((String)NLS.bind((String)OpenShiftUIMessages.EmptyHostNameErrorMessage, (Object)hostName));
                    } else if (!DomainValidator.getInstance((boolean)true).isValid(hostName)) {
                        status = ValidationStatus.error((String)NLS.bind((String)OpenShiftUIMessages.InvalidHostNameErrorMessage, (Object)hostName));
                    }
                    if (!status.matches(4) && isAddRoute && portsObservable.size() > 1 && routingPort == null) {
                        status = status.matches(1) ? ValidationStatus.info((String)(String.valueOf(status.getMessage()) + "\n " + OpenShiftUIMessages.RoundRobinRoutingMessage)) : ValidationStatus.info((String)OpenShiftUIMessages.RoundRobinRoutingMessage);
                    }
                }
                return status;
            }
        };
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        ControlDecorationSupport.create((ValidationStatusProvider)validator, (int)16512);
    }

    private void createExposedPortsControl(Composite parent, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(container);
        Label label = new Label(container, 0);
        label.setText("Service Ports:");
        label.setToolTipText("The exposed ports of the image.");
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).applyTo((Control)label);
        Composite tableContainer = new Composite(container, 0);
        final IObservableList portsObservable = BeanProperties.list((String)"servicePorts").observe((Object)this.model);
        this.portsViewer = this.createTable(tableContainer);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.portsViewer.setContentProvider((IContentProvider)contentProvider);
        ObservableMapLabelProvider labelProvider = new ObservableMapLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])BeanProperties.values((String[])new String[]{"name", "port", "targetPort", "routePort"}))){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 3) {
                    Object selected = this.attributeMaps[columnIndex].get(element);
                    return selected != null && (Boolean)selected != false ? OpenShiftImages.CHECKED_IMG : OpenShiftImages.UNCHECKED_IMG;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex != 3) {
                    Object result = this.attributeMaps[columnIndex].get(element);
                    return result == null ? ServicesAndRoutingPage.PAGE_DESCRIPTION : result.toString();
                }
                return null;
            }
        };
        this.portsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.portsViewer)).to(BeanProperties.value((String)"selectedServicePort").observe((Object)this.model)).in(dbc);
        this.portsViewer.setInput((Object)portsObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

            protected IStatus validate() {
                if (portsObservable.isEmpty()) {
                    return ValidationStatus.error((String)"At least 1 port is required when generating the service for the deployed image");
                }
                return Status.OK_STATUS;
            }
        });
        this.portsViewer.getTable().addMouseListener(this.onTableCellClicked());
        Button btnEdit = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)btnEdit);
        btnEdit.setText("Edit...");
        btnEdit.setToolTipText("Edit a port to be exposed by the service.");
        btnEdit.addSelectionListener((SelectionListener)new EditHandler());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnEdit)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedServicePort").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        UIUtils.setDefaultButtonWidth((Button)btnEdit);
        Button btnReset = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)btnReset);
        btnReset.setText("Reset");
        btnReset.setToolTipText("Resets the list of ports to the exposed ports of the image.");
        btnReset.addSelectionListener(this.onReset());
        UIUtils.setDefaultButtonWidth((Button)btnReset);
    }

    private MouseListener onTableCellClicked() {
        return new TableCellMouseAdapter(3){

            public void mouseUpCell(MouseEvent event) {
                ServicePortAdapter target;
                IServicePort port = ServicesAndRoutingPage.this.model.getSelectedServicePort();
                target.setRoutePort(!(target = new ServicePortAdapter((ServicePortAdapter)port)).isRoutePort());
                target.setName(NLS.bind((String)"{0}-tcp", (Object)target.getPort()));
                ServicesAndRoutingPage.this.model.updateServicePort(port, target);
                ServicesAndRoutingPage.this.model.setSelectedServicePort(target);
                Display.getDefault().asyncExec(() -> {
                    if (ServicesAndRoutingPage.this.portsViewer != null && ServicesAndRoutingPage.this.portsViewer.getTable() != null && !ServicesAndRoutingPage.this.portsViewer.getTable().isDisposed()) {
                        ServicesAndRoutingPage.this.portsViewer.refresh();
                    }
                });
            }
        };
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewer viewer = new TableViewerBuilder(table, tableContainer).column("Name").align(16384).weight(2).minWidth(50).buildColumn().column("Service Port").align(16384).weight(1).minWidth(25).buildColumn().column("Pod Port").align(16384).weight(1).minWidth(25).buildColumn().column((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                boolean selected = ((ServicePortAdapter)((Object)element)).isRoutePort();
                return selected ? OpenShiftImages.CHECKED_IMG : OpenShiftImages.UNCHECKED_IMG;
            }

            public String getText(Object element) {
                return null;
            }
        }).name("Used by route").align(16384).weight(1).buildColumn().buildViewer();
        viewer.addDoubleClickListener((IDoubleClickListener)new EditHandler());
        viewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                return System.identityHashCode(element);
            }

            public boolean equals(Object a, Object b) {
                return a == b;
            }
        });
        return viewer;
    }

    private SelectionListener onReset() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)ServicesAndRoutingPage.this.getShell(), (String)"Reset ports", (String)"Are you sure you want to reset the serviced ports to those exposed by the image?")) {
                    ServicesAndRoutingPage.this.model.resetServicePorts();
                }
            }
        };
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }

    class EditHandler
    extends SelectionAdapter
    implements IDoubleClickListener {
        EditHandler() {
        }

        public void doubleClick(DoubleClickEvent event) {
            this.handleEvent();
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleEvent();
        }

        public void handleEvent() {
            String message = "Edit the port to be exposed by the service";
            IServicePort port = ServicesAndRoutingPage.this.model.getSelectedServicePort();
            ServicePortAdapter target = new ServicePortAdapter((ServicePortAdapter)port);
            ServicePortDialog dialog = new ServicePortDialog(target, message, ServicesAndRoutingPage.this.model.getServicePorts());
            if (dialog.open() == 0) {
                target.setName(NLS.bind((String)"{0}-tcp", (Object)target.getPort()));
                ServicesAndRoutingPage.this.model.updateServicePort(port, target);
                ServicesAndRoutingPage.this.model.setSelectedServicePort(target);
            }
        }
    }
}

