/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.linuxtools.docker.core.IRepositoryTag;
import org.jboss.dmr.ModelNode;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.search.InvalidDockerRegistryException;

public class DockerHubRegistry {
    private static final String REGISTRY_LOCATION = "https://registry.hub.docker.com/";

    public List<String> getTags(String repoName) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpGet pingApiV1Request = new HttpGet(URIBuilder.target(REGISTRY_LOCATION).path("v1").path("_ping").toString());
            pingApiV1Request.setHeader("Accept", "application/json");
            HttpResponse pingApiV1Response = httpClient.execute((HttpUriRequest)pingApiV1Request);
            if (pingApiV1Response.getStatusLine().getStatusCode() != 200) {
                throw new InvalidDockerRegistryException(REGISTRY_LOCATION);
            }
            HttpGet getTagsRequest = new HttpGet(URIBuilder.target(REGISTRY_LOCATION).path("v1").path("repositories").path(repoName).path("tags").toString());
            getTagsRequest.setHeader("Accept", "application/json");
            HttpResponse getTagsResponse = httpClient.execute((HttpUriRequest)getTagsRequest);
            if (getTagsResponse.getStatusLine().getStatusCode() != 200) {
                return Collections.emptyList();
            }
            ModelNode tags = ModelNode.fromJSONStream((InputStream)getTagsResponse.getEntity().getContent());
            return tags.asList().stream().map(node -> node.get("name").asString()).collect(Collectors.toList());
        }
        catch (IOException e) {
            OpenShiftUIActivator.getDefault().getLogger().logError("Failed to retrieve the tags for image named '" + repoName + "'", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Deprecated
    public class RepositoryTag
    implements IRepositoryTag {
        private String layer;
        private String name;

        public String getLayer() {
            return this.layer;
        }

        public void setLayer(String layer) {
            this.layer = layer;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class URIBuilder {
        private final StringBuilder uri;

        private URIBuilder(String target) {
            this.uri = new StringBuilder(target);
        }

        public static URIBuilder target(String target) {
            return new URIBuilder(target);
        }

        public URIBuilder path(String path) {
            if (path.charAt(0) != '/') {
                this.uri.append('/');
            }
            this.uri.append(path);
            return this;
        }

        public String toString() {
            return this.uri.toString();
        }
    }
}

